/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.aggregates;

import com.google.common.collect.ImmutableList;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.EntityCountMetric;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.TransientVariableScope;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.parser.Expression;
import io.cdap.wrangler.api.parser.Identifier;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.expression.EL;
import io.cdap.wrangler.expression.ELContext;
import io.cdap.wrangler.expression.ELException;
import io.cdap.wrangler.expression.ELResult;
import io.cdap.wrangler.metrics.JexlCategoryMetricUtils;
import java.util.List;

@Plugin(type="directive")
@Name(value="set-variable")
@Categories(categories={"transient"})
@Description(value="Sets the value for a transient variable for the record being processed.")
public class SetTransientVariable
implements Directive {
    public static final String NAME = "set-variable";
    private EL el;
    private String variable;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("variable", TokenType.IDENTIFIER);
        builder.define("condition", TokenType.EXPRESSION);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.variable = ((Identifier)args.value("variable")).value();
        String expression = ((Expression)args.value("condition")).value();
        try {
            this.el = EL.compile(expression);
        }
        catch (ELException e) {
            throw new DirectiveParseException(NAME, e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            ELContext ctx = new ELContext(context, this.el, row);
            try {
                ELResult result = this.el.execute(ctx);
                if (context == null) continue;
                context.getTransientStore().set(TransientVariableScope.GLOBAL, this.variable, result.getObject());
            }
            catch (ELException e) {
                throw new DirectiveExecutionException(NAME, e.getMessage(), (Throwable)e);
            }
        }
        return rows;
    }

    public List<EntityCountMetric> getCountMetrics() {
        EntityCountMetric jexlCategoryMetric = JexlCategoryMetricUtils.getJexlCategoryMetric(this.el.getScriptParsedText());
        return jexlCategoryMetric == null ? null : ImmutableList.of((Object)jexlCategoryMetric);
    }
}

