/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.aggregates;

import io.cdap.wrangler.api.TransientStore;
import io.cdap.wrangler.api.TransientVariableScope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultTransientStore
implements TransientStore {
    private final Map<String, Object> global = new HashMap<String, Object>();
    private final Map<String, Object> local = new HashMap<String, Object>();

    public void increment(TransientVariableScope scope, String name, long value) {
        if (scope == TransientVariableScope.GLOBAL) {
            this.increment(this.global, name, value);
        } else if (scope == TransientVariableScope.LOCAL) {
            this.increment(this.local, name, value);
        }
    }

    private void increment(Map<String, Object> variables, String name, long value) {
        Long count = null;
        if (variables.containsKey(name)) {
            count = (Long)variables.get(name);
        }
        if (count == null) {
            count = 0L;
        }
        variables.put(name, count + value);
    }

    public Set<String> getVariables() {
        HashSet<String> vars = new HashSet<String>(this.global.keySet());
        vars.addAll(this.local.keySet());
        return vars;
    }

    public void reset(TransientVariableScope scope) {
        if (scope == TransientVariableScope.GLOBAL) {
            this.global.clear();
        } else if (scope == TransientVariableScope.LOCAL) {
            this.local.clear();
        }
    }

    public <T> T get(String name) {
        if (this.global.containsKey(name)) {
            return (T)this.global.get(name);
        }
        return (T)this.local.get(name);
    }

    public void set(TransientVariableScope scope, String name, Object value) {
        if (scope == TransientVariableScope.GLOBAL) {
            this.global.put(name, value);
        } else if (scope == TransientVariableScope.LOCAL) {
            this.local.put(name, value);
        }
    }
}

