/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api.parser;

import io.cdap.wrangler.api.parser.TokenDefinition;
import io.cdap.wrangler.api.parser.TokenType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class UsageDefinition
implements Serializable {
    private final transient int optionalCnt;
    private final String directive;
    private final List<TokenDefinition> tokens;

    private UsageDefinition(String directive, int optionalCnt, List<TokenDefinition> tokens) {
        this.directive = directive;
        this.tokens = tokens;
        this.optionalCnt = optionalCnt;
    }

    public String getDirectiveName() {
        return this.directive;
    }

    public List<TokenDefinition> getTokens() {
        return this.tokens;
    }

    public int getOptionalTokensCount() {
        return this.optionalCnt;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.directive).append(" ");
        int count = this.tokens.size();
        for (TokenDefinition token : this.tokens) {
            if (token.optional()) {
                sb.append(" [");
            }
            if (token.label() != null) {
                sb.append(token.label());
            } else if (token.type().equals(TokenType.DIRECTIVE_NAME)) {
                sb.append(token.name());
            } else if (token.type().equals(TokenType.COLUMN_NAME)) {
                sb.append(":").append(token.name());
            } else if (token.type().equals(TokenType.COLUMN_NAME_LIST)) {
                sb.append(":").append(token.name()).append(" [,:").append(token.name()).append("  ]*");
            } else if (token.type().equals(TokenType.BOOLEAN)) {
                sb.append(token.name()).append(" (true/false)");
            } else if (token.type().equals(TokenType.TEXT)) {
                sb.append("'").append(token.name()).append("'");
            } else if (token.type().equals(TokenType.IDENTIFIER) || token.type().equals(TokenType.NUMERIC)) {
                sb.append(token.name());
            } else if (token.type().equals(TokenType.BOOLEAN_LIST) || token.type().equals(TokenType.NUMERIC_LIST) || token.type().equals(TokenType.TEXT_LIST)) {
                sb.append(token.name()).append("[,").append(token.name()).append(" ...]*");
            } else if (token.type().equals(TokenType.EXPRESSION)) {
                sb.append("exp:{<").append(token.name()).append(">}");
            } else if (token.type().equals(TokenType.PROPERTIES)) {
                sb.append("prop:{key:value,[key:value]*");
            } else if (token.type().equals(TokenType.RANGES)) {
                sb.append("start:end=[bool|text|numeric][,start:end=[bool|text|numeric]*");
            }
            --count;
            if (token.optional()) {
                sb.append("]");
                continue;
            }
            if (count <= 0) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static Builder builder(String directive) {
        return new Builder(directive);
    }

    public static final class Builder {
        private final String directive;
        private final List<TokenDefinition> tokens;
        private int currentOrdinal;
        private int optionalCnt;

        public Builder(String directive) {
            this.directive = directive;
            this.currentOrdinal = 0;
            this.tokens = new ArrayList<TokenDefinition>();
            this.optionalCnt = 0;
        }

        public void define(String name, TokenType type) {
            TokenDefinition spec = new TokenDefinition(name, type, null, this.currentOrdinal, false);
            ++this.currentOrdinal;
            this.tokens.add(spec);
        }

        public void define(String name, TokenType type, String label) {
            TokenDefinition spec = new TokenDefinition(name, type, label, this.currentOrdinal, false);
            ++this.currentOrdinal;
            this.tokens.add(spec);
        }

        public void define(String name, TokenType type, boolean optional) {
            TokenDefinition spec = new TokenDefinition(name, type, null, this.currentOrdinal, optional);
            this.optionalCnt = optional ? this.optionalCnt + 1 : this.optionalCnt;
            ++this.currentOrdinal;
            this.tokens.add(spec);
        }

        public void define(String name, TokenType type, String label, boolean optional) {
            TokenDefinition spec = new TokenDefinition(name, type, label, this.currentOrdinal, optional);
            this.optionalCnt = optional ? this.optionalCnt + 1 : this.optionalCnt;
            ++this.currentOrdinal;
            this.tokens.add(spec);
        }

        public UsageDefinition build() {
            return new UsageDefinition(this.directive, this.optionalCnt, this.tokens);
        }
    }
}

