/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api.lineage;

import io.cdap.cdap.api.annotation.Beta;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Relation;
import io.cdap.wrangler.api.parser.ColumnName;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

@Beta
public final class Mutation
implements Serializable {
    private static final long serialVersionUID = 1243542667080258334L;
    private final String readable;
    private final List<Relation> relations;

    private Mutation() {
        this("", Collections.emptyList());
    }

    private Mutation(String readable, List<Relation> relations) {
        this.readable = readable;
        this.relations = Collections.unmodifiableList(new ArrayList<Relation>(relations));
    }

    public String readable() {
        return this.readable;
    }

    public List<Relation> relations() {
        return this.relations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Relation> relations = new ArrayList<Relation>();
        private String description;

        public Builder readable(String format, Object ... args) {
            this.description = String.format(format, args);
            return this;
        }

        public Builder readable(String format, List<Object> args) {
            this.readable(format, args.toArray());
            return this;
        }

        public Builder drop(Many sources) {
            this.relations.add(new Relation(this.uuid(), sources.columns(), Collections.emptyList(), Relation.Type.DROP));
            return this;
        }

        public Builder create(Many targets) {
            this.relations.add(new Relation(this.uuid(), Collections.emptyList(), targets.columns(), Relation.Type.CREATE));
            return this;
        }

        public Builder generate(Many targets) {
            this.relations.add(new Relation(this.uuid(), Collections.emptyList(), targets.columns(), Relation.Type.GENERATE));
            return this;
        }

        public Builder all(Many sources) {
            this.relations.add(new Relation(this.uuid(), sources.columns(), Collections.emptyList(), Relation.Type.ALL));
            return this;
        }

        public Builder all(Many sources, Many targets) {
            this.relations.add(new Relation(sources.columns(), targets.columns(), Relation.Type.ALL));
            return this;
        }

        public Builder relation(ColumnName source, ColumnName target) {
            this.relation(source.value(), target.value());
            return this;
        }

        public Builder conditional(String source, String target) {
            this.relation(source, source.equals(target) ? Many.of(target) : Many.of(source, target));
            return this;
        }

        public Builder relation(String source, String target) {
            this.relation(source, Many.of(target));
            return this;
        }

        public Builder relation(ColumnName source, Many targets) {
            this.relation(source.value(), targets);
            return this;
        }

        public Builder relation(String source, Many targets) {
            this.relation(Many.of(source), targets);
            return this;
        }

        public Builder relation(Many sources, String target) {
            this.relation(sources, Many.of(target));
            return this;
        }

        public Builder relation(Many sources, Many targets) {
            this.relations.add(new Relation(this.uuid(), sources.columns(), targets.columns()));
            return this;
        }

        public Builder relation(Many sources, ColumnName target) {
            this.relation(sources, target.value());
            return this;
        }

        private String uuid() {
            return UUID.randomUUID().toString();
        }

        public Mutation build() {
            return new Mutation(this.description, this.relations);
        }
    }
}

