/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cdap.wrangler.api.SourceInfo;
import io.cdap.wrangler.api.TokenGroup;
import io.cdap.wrangler.api.annotations.PublicEvolving;
import io.cdap.wrangler.api.parser.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@PublicEvolving
public final class RecipeSymbol {
    private final String version;
    private final Set<String> loadableDirectives;
    private final List<TokenGroup> tokens;

    private RecipeSymbol(String version, Set<String> loadableDirectives, List<TokenGroup> tokens) {
        this.version = version;
        this.loadableDirectives = loadableDirectives;
        this.tokens = tokens;
    }

    public Set<String> getLoadableDirectives() {
        return this.loadableDirectives;
    }

    public String getVersion() {
        return this.version;
    }

    public int size() {
        return this.tokens.size();
    }

    public Iterator<TokenGroup> iterator() {
        return this.tokens.iterator();
    }

    public static Builder builder() {
        return new Builder();
    }

    public JsonElement toJson() {
        JsonObject output = new JsonObject();
        output.addProperty("class", this.getClass().getSimpleName());
        output.addProperty("count", (Number)this.tokens.size());
        JsonArray array = new JsonArray();
        for (TokenGroup token : this.tokens) {
            JsonArray darray = new JsonArray();
            Iterator<Token> it = token.iterator();
            while (it.hasNext()) {
                Token tok = it.next();
                JsonObject object = new JsonObject();
                object.addProperty("token", tok.type().toString());
                object.addProperty("value", tok.value().toString());
                darray.add((JsonElement)object);
            }
            array.add((JsonElement)darray);
        }
        output.add("value", (JsonElement)array);
        return output;
    }

    public static final class Builder {
        private final List<TokenGroup> groups = new ArrayList<TokenGroup>();
        private final Set<String> loadableDirectives = new TreeSet<String>();
        private TokenGroup group = null;
        private String version = "1.0";

        public void createTokenGroup(SourceInfo info) {
            if (this.group != null) {
                this.groups.add(this.group);
            }
            this.group = new TokenGroup(info);
        }

        public void addToken(Token token) {
            this.group.add(token);
        }

        public void addVersion(String version) {
            this.version = version;
        }

        public void addLoadableDirective(String directive) {
            this.loadableDirectives.add(directive);
        }

        public RecipeSymbol build() {
            this.groups.add(this.group);
            return new RecipeSymbol(this.version, this.loadableDirectives, this.groups);
        }
    }
}

