/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api;

public class ErrorRowException
extends Exception {
    private String message;
    private int code;
    private boolean showInWrangler;

    public ErrorRowException(String message, int code, boolean showInWrangler) {
        this(message, code, showInWrangler, null);
    }

    public ErrorRowException(String message, int code, boolean showInWrangler, Throwable cause) {
        super(message, cause);
        this.message = message;
        this.code = code;
        this.showInWrangler = showInWrangler;
    }

    public ErrorRowException(String message, int code) {
        this(message, code, false);
    }

    public ErrorRowException(String directiveName, String errorMessage, int code) {
        this(directiveName, errorMessage, code, null);
    }

    public ErrorRowException(String directiveName, String errorMessage, int code, Throwable cause) {
        this(String.format("%s (ecode: %d, directive: %s)", errorMessage, code, directiveName), code, false, cause);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isShownInWrangler() {
        return this.showInWrangler;
    }
}

