/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api;

import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.api.annotations.PublicEvolving;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@PublicEvolving
public final class Row
implements Serializable {
    private static final long serialVersionUID = -7505703059736709602L;
    private List<String> columns = new ArrayList<String>();
    private List<Object> values = new ArrayList<Object>();

    public Row() {
    }

    public Row(Row row) {
        this.values = new ArrayList<Object>(row.values);
        this.columns = new ArrayList<String>(row.columns);
    }

    public Row(List<String> columns) {
        this.columns = new ArrayList<String>(columns);
        this.values = new ArrayList<Object>(columns.size());
    }

    public Row(String name, Object value) {
        this.columns = new ArrayList<String>(1);
        this.values = new ArrayList<Object>(1);
        this.columns.add(name);
        this.values.add(value);
    }

    public String getColumn(int idx) {
        return this.columns.get(idx);
    }

    public void setColumn(int idx, String name) {
        this.columns.set(idx, name);
    }

    public Object getValue(int idx) {
        return this.values.get(idx);
    }

    public Object getValue(String col) {
        int idx;
        if (col != null && !col.isEmpty() && (idx = this.find(col)) != -1) {
            return this.values.get(idx);
        }
        return null;
    }

    public Row setValue(int idx, Object value) {
        this.values.set(idx, value);
        return this;
    }

    public Row add(String name, Object value) {
        this.columns.add(name);
        this.values.add(value);
        return this;
    }

    public Row remove(int idx) {
        this.columns.remove(idx);
        this.values.remove(idx);
        return this;
    }

    public int find(String col) {
        return this.find(col, 0);
    }

    public int find(String col, int firstIdx) {
        int columnsSize = this.columns.size();
        for (int i = firstIdx; i < columnsSize; ++i) {
            String name = this.columns.get(i);
            if (!col.equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public int length() {
        return this.columns.size();
    }

    public int width() {
        return this.columns.size();
    }

    public List<Pair<String, Object>> getFields() {
        ArrayList<Pair<String, Object>> v = new ArrayList<Pair<String, Object>>();
        int i = 0;
        for (String column : this.columns) {
            v.add(new Pair<String, Object>(column, this.values.get(i)));
            ++i;
        }
        return v;
    }

    public void addOrSet(String name, Object value) {
        int idx = this.find(name);
        if (idx != -1) {
            this.setValue(idx, value);
        } else {
            this.add(name, value);
        }
    }

    public void addOrSetAtIndex(int index, String name, Object value) {
        int idx = this.find(name);
        if (idx != -1) {
            this.setValue(idx, value);
        } else if (index < this.columns.size() && index < this.values.size()) {
            this.columns.add(index, name);
            this.values.add(index, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row row = (Row)o;
        return Objects.equals(this.columns, row.columns) && Objects.equals(this.values, row.values);
    }

    public int hashCode() {
        return Objects.hash(this.columns, this.values);
    }
}

