/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cdap.wrangler.api.annotations.PublicEvolving;
import io.cdap.wrangler.api.parser.Token;
import io.cdap.wrangler.api.parser.TokenType;
import java.util.Map;

@PublicEvolving
public class Properties
implements Token {
    private Map<String, Token> values;

    public Properties(Map<String, Token> values) {
        this.values = values;
    }

    @Override
    public Map<String, Token> value() {
        return this.values;
    }

    @Override
    public TokenType type() {
        return TokenType.PROPERTIES;
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        for (Map.Entry<String, Token> entry : this.values.entrySet()) {
            object.add(entry.getKey(), entry.getValue().toJson());
        }
        return object;
    }
}

