/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.cdap.wrangler.api.annotations.PublicEvolving;
import io.cdap.wrangler.api.parser.Token;
import io.cdap.wrangler.api.parser.TokenType;
import java.util.List;

@PublicEvolving
public class TextList
implements Token {
    private List<String> values;

    public TextList(List<String> values) {
        this.values = values;
    }

    @Override
    public List<String> value() {
        return this.values;
    }

    @Override
    public TokenType type() {
        return TokenType.TEXT_LIST;
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", TokenType.TEXT_LIST.name());
        JsonArray array = new JsonArray();
        for (String value : this.values) {
            array.add((JsonElement)new JsonPrimitive(value));
        }
        object.add("value", (JsonElement)array);
        return object;
    }
}

