/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.cdap.wrangler.api.LazyNumber;
import io.cdap.wrangler.api.annotations.PublicEvolving;
import io.cdap.wrangler.api.parser.Token;
import io.cdap.wrangler.api.parser.TokenType;
import java.util.List;

@PublicEvolving
public class NumericList
implements Token {
    private final List<LazyNumber> values;

    public NumericList(List<LazyNumber> values) {
        this.values = values;
    }

    @Override
    public List<LazyNumber> value() {
        return this.values;
    }

    @Override
    public TokenType type() {
        return TokenType.NUMERIC_LIST;
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", TokenType.NUMERIC_LIST.name());
        JsonArray array = new JsonArray();
        for (LazyNumber value : this.values) {
            array.add((JsonElement)new JsonPrimitive((Number)value));
        }
        object.add("value", (JsonElement)array);
        return object;
    }
}

