/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cdap.wrangler.api.LazyNumber;
import io.cdap.wrangler.api.annotations.PublicEvolving;
import io.cdap.wrangler.api.parser.Token;
import io.cdap.wrangler.api.parser.TokenType;

@PublicEvolving
public class Numeric
implements Token {
    private final LazyNumber value;

    public Numeric(LazyNumber value) {
        this.value = value;
    }

    @Override
    public LazyNumber value() {
        return this.value;
    }

    @Override
    public TokenType type() {
        return TokenType.NUMERIC;
    }

    @Override
    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", TokenType.NUMERIC.name());
        object.addProperty("value", (Number)this.value);
        return object;
    }
}

