/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public final class SourceInfo {
    private final int lineno;
    private final int colno;
    private final String source;

    public SourceInfo(int lineno, int colno, String source) {
        this.lineno = lineno;
        this.colno = colno;
        this.source = source;
    }

    public int getLineNumber() {
        return this.lineno;
    }

    public int getColumnNumber() {
        return this.colno;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return String.format("%3d:%-3d - '%s'", this.lineno, this.colno, this.source);
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("line", (Number)this.lineno);
        object.addProperty("column", (Number)this.colno);
        object.addProperty("source", this.source);
        return object;
    }
}

