/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.cdap.cdap.api.annotation.UseDataSet;
import io.cdap.cdap.api.dataset.table.Table;
import io.cdap.cdap.api.service.http.AbstractHttpServiceHandler;
import io.cdap.cdap.api.service.http.HttpServiceContext;
import io.cdap.cdap.api.service.http.HttpServiceRequest;
import io.cdap.cdap.api.service.http.HttpServiceResponder;
import io.cdap.re.RequestExtractor;
import io.cdap.re.RuleAlreadyExistsException;
import io.cdap.re.RuleNotFoundException;
import io.cdap.re.RuleRequest;
import io.cdap.re.Rulebook;
import io.cdap.re.RulebookAlreadyExistsException;
import io.cdap.re.RulebookCompiler;
import io.cdap.re.RulebookNotFoundException;
import io.cdap.re.RulebookRequest;
import io.cdap.re.RulesDB;
import io.cdap.re.ServiceUtils;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.jexl3.JexlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YARERulebookService
extends AbstractHttpServiceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(YARERulebookService.class);
    private static final Gson gson = new Gson();
    @UseDataSet(value="rules")
    private Table rules;
    @UseDataSet(value="rulebook")
    private Table rulebook;
    private RulesDB rulesDB;

    public void initialize(HttpServiceContext context) throws Exception {
        super.initialize(context);
        this.rulesDB = new RulesDB(this.rulebook, this.rules, context.getMessagePublisher());
    }

    @GET
    @Path(value="health")
    public void healthCheck(HttpServiceRequest request, HttpServiceResponder responder) {
        responder.sendStatus(200);
    }

    @POST
    @Path(value="validate-when")
    public void validateWhen(HttpServiceRequest request, HttpServiceResponder responder) {
        try {
            ServiceUtils.success(responder, "Valid when clause");
        }
        catch (JexlException e) {
            ServiceUtils.error(responder, 400, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, e.getMessage());
        }
    }

    @POST
    @Path(value="rules")
    public void create(HttpServiceRequest request, HttpServiceResponder responder) {
        try {
            RequestExtractor handler = new RequestExtractor(request);
            String content = handler.getContent(StandardCharsets.UTF_8);
            RuleRequest rule = (RuleRequest)gson.fromJson(content, RuleRequest.class);
            this.rulesDB.createRule(rule);
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully created rule '%s'.", rule.getId()));
            response.addProperty("count", (Number)1);
            JsonArray values = new JsonArray();
            values.add((JsonElement)new JsonPrimitive(rule.getId()));
            response.add("values", (JsonElement)values);
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (RuleAlreadyExistsException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unexpected error while creating rule. Please check your request. %s", e.getMessage()));
        }
    }

    @GET
    @Path(value="rules")
    public void rules(HttpServiceRequest request, HttpServiceResponder responder) {
        try {
            List<Map<String, Object>> rules = this.rulesDB.rules();
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully listed rules.", new Object[0]));
            response.addProperty("count", (Number)rules.size());
            response.add("values", gson.toJsonTree(rules));
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unexpected error while listing rules. Please check your request. %s", e.getMessage()));
        }
    }

    @PUT
    @Path(value="rules/{rule-id}")
    public void update(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rule-id") String id) {
        try {
            RequestExtractor handler = new RequestExtractor(request);
            String content = handler.getContent(StandardCharsets.UTF_8);
            RuleRequest rule = (RuleRequest)gson.fromJson(content, RuleRequest.class);
            this.rulesDB.updateRule(id, rule);
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully updated rule '%s'.", id));
            response.addProperty("count", (Number)1);
            JsonArray values = new JsonArray();
            values.add((JsonElement)new JsonPrimitive(id));
            response.add("values", (JsonElement)values);
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (RuleNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unexpected error while updating rule. Please check your request. %s", e.getMessage()));
        }
    }

    @GET
    @Path(value="rules/{rule-id}")
    public void retrieve(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rule-id") String id, @QueryParam(value="format") String format) {
        try {
            Map<String, Object> result = this.rulesDB.retrieveRule(id);
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully retrieved rule '%s'.", id));
            response.addProperty("count", (Number)1);
            if (format == null || format.equalsIgnoreCase("json")) {
                response.add("values", gson.toJsonTree(result));
            } else {
                JsonArray array = new JsonArray();
                array.add((JsonElement)new JsonPrimitive(this.rulesDB.retrieveUsingRuleTemplate(id)));
                response.add("values", (JsonElement)array);
            }
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (RuleNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unexpected error while retrieving rule. Please check your request. %s", e.getMessage()));
        }
    }

    @DELETE
    @Path(value="rules/{rule-id}")
    public void delete(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rule-id") String id) {
        try {
            this.rulesDB.deleteRule(id);
            ServiceUtils.success(responder, String.format("Successfully deleted rule '%s'", id));
        }
        catch (RuleNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unexpected error while deleting the rule. Please check your request. %s", e.getMessage()));
        }
    }

    @POST
    @Path(value="rulebooks")
    public void createRb(HttpServiceRequest request, HttpServiceResponder responder) {
        try {
            String id;
            RequestExtractor handler = new RequestExtractor(request);
            String content = handler.getContent(StandardCharsets.UTF_8);
            if (handler.isContentType("application/json")) {
                RulebookRequest rb = (RulebookRequest)gson.fromJson(content, RulebookRequest.class);
                this.rulesDB.createRulebook(rb);
                id = rb.getId();
            } else if (handler.isContentType("application/rules-engine")) {
                StringReader reader = new StringReader(content);
                RulebookCompiler compiler = new RulebookCompiler();
                Rulebook rulebook = compiler.compile(reader);
                this.rulesDB.createRulebook(rulebook);
                id = rulebook.getName();
            } else {
                String header = (String)handler.getHeader("Content-Type", "");
                ServiceUtils.error(responder, 400, "Unsupported content type " + header + ".");
                return;
            }
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully created rulebook '%s'.", id));
            response.addProperty("count", (Number)1);
            JsonArray values = new JsonArray();
            values.add((JsonElement)new JsonPrimitive(id));
            response.add("values", (JsonElement)values);
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (RulebookAlreadyExistsException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unexpected error while creating rulebook. Please check your request. %s", e.getMessage()));
        }
    }

    @GET
    @Path(value="rulebooks")
    public void rulebooks(HttpServiceRequest request, HttpServiceResponder responder) {
        try {
            List<Map<String, Object>> rulebooks = this.rulesDB.rulebooks();
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully listed rulebooks.", new Object[0]));
            response.addProperty("count", (Number)rulebooks.size());
            response.add("values", gson.toJsonTree(rulebooks));
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unable to list all rulebooks. %s", e.getMessage()));
        }
    }

    @PUT
    @Path(value="rulebooks/{rulebook-id}")
    public void updateRb(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rulebook-id") String id) {
        try {
            RequestExtractor handler = new RequestExtractor(request);
            String content = handler.getContent(StandardCharsets.UTF_8);
            RulebookRequest rulebook = (RulebookRequest)gson.fromJson(content, RulebookRequest.class);
            this.rulesDB.updateRulebook(id, rulebook);
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully updated rule '%s'.", id));
            response.addProperty("count", (Number)1);
            JsonArray values = new JsonArray();
            values.add((JsonElement)new JsonPrimitive(id));
            response.add("values", (JsonElement)values);
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (RuleNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unable to update rulebook. %s", e.getMessage()));
        }
    }

    @GET
    @Path(value="rulebooks/{rulebook-id}")
    public void retrieveRb(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rulebook-id") String id) {
        try {
            String rulebookString = this.rulesDB.generateRulebook(id);
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully generated rulebook '%s'.", id));
            response.addProperty("count", (Number)1);
            JsonArray values = new JsonArray();
            values.add((JsonElement)new JsonPrimitive(rulebookString));
            response.add("values", (JsonElement)values);
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (RuleNotFoundException | RulebookNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unable to retrieve rulebook. %s", e.getMessage()));
        }
    }

    @GET
    @Path(value="rulebooks/{rulebook-id}/rules")
    public void retrieveRbRules(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rulebook-id") String id) {
        try {
            JsonArray rules = this.rulesDB.getRulebookRules(id);
            JsonObject response = new JsonObject();
            response.addProperty("status", (Number)200);
            response.addProperty("message", String.format("Successfully listed rules for the rulebook '%s'.", id));
            response.addProperty("count", (Number)rules.size());
            response.add("values", (JsonElement)rules);
            ServiceUtils.sendJson(responder, 200, response.toString());
        }
        catch (RuleNotFoundException | RulebookNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unable to retrieve rules for rulebook. %s", e.getMessage()));
        }
    }

    @DELETE
    @Path(value="rulebooks/{rulebook-id}")
    public void deleteRb(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rulebook-id") String id) {
        try {
            this.rulesDB.deleteRulebook(id);
            ServiceUtils.success(responder, String.format("Successfully deleted rulebook '%s'", id));
        }
        catch (RulebookNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unable to delete rulebook. %s", e.getMessage()));
        }
    }

    @PUT
    @Path(value="rulebooks/{rulebook-id}/rules/{rule-id}")
    public void addRuleToRb(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rulebook-id") String rbId, @PathParam(value="rule-id") String id) {
        try {
            this.rulesDB.addRuleToRulebook(rbId, id);
            ServiceUtils.success(responder, String.format("Successfully added rule '%s' to rulebook '%s'", id, rbId));
        }
        catch (RuleNotFoundException | RulebookNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unable to add rule to rulebook. %s", e.getMessage()));
        }
    }

    @DELETE
    @Path(value="rulebooks/{rulebook-id}/rules/{rule-id}")
    public void deleteRuleFromRb(HttpServiceRequest request, HttpServiceResponder responder, @PathParam(value="rulebook-id") String rbId, @PathParam(value="rule-id") String id) {
        try {
            this.rulesDB.removeRuleFromRulebook(rbId, id);
            ServiceUtils.success(responder, String.format("Successfully removed rule '%s' to rulebook '%s'", id, rbId));
        }
        catch (RuleNotFoundException | RulebookNotFoundException e) {
            ServiceUtils.error(responder, 404, e.getMessage());
        }
        catch (Exception e) {
            ServiceUtils.error(responder, 500, String.format("Unable to remove rule from rulebook. %s", e.getMessage()));
        }
    }
}

