/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import com.google.common.base.Joiner;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.dataset.table.Row;
import io.cdap.cdap.api.dataset.table.Scanner;
import io.cdap.cdap.api.dataset.table.Table;
import io.cdap.cdap.api.messaging.MessagePublisher;
import io.cdap.re.Rule;
import io.cdap.re.RuleAlreadyExistsException;
import io.cdap.re.RuleNotFoundException;
import io.cdap.re.RuleRequest;
import io.cdap.re.Rulebook;
import io.cdap.re.RulebookAlreadyExistsException;
import io.cdap.re.RulebookNotFoundException;
import io.cdap.re.RulebookRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RulesDB {
    private static final Logger LOG = LoggerFactory.getLogger(RulesDB.class);
    private final Table rulebook;
    private final Table rules;
    private final MessagePublisher publisher;
    private static final String RULE_TEMPLATE = "\n  rule %s {\n    description '%s'\n    when(%s) then {\n      %s\n    }\n  }\n";
    private static final String RULEBOOK_TEMPLATE = "rulebook %s {\n  version %d\n\n  meta {\n    description '%s'\n    created-date %d\n    updated-date %d\n    source '%s'\n    user '%s'\n  }\n  %s\n}";
    private static final byte[] ID = Bytes.toBytes((String)"id");
    private static final byte[] DESCRIPTION = Bytes.toBytes((String)"description");
    private static final byte[] CONDITION = Bytes.toBytes((String)"condition");
    private static final byte[] ACTION = Bytes.toBytes((String)"action");
    private static final byte[] CREATED = Bytes.toBytes((String)"created");
    private static final byte[] UPDATED = Bytes.toBytes((String)"updated");
    private static final byte[] USER = Bytes.toBytes((String)"user");
    private static final byte[] SOURCE = Bytes.toBytes((String)"source");
    private static final byte[] VERSION = Bytes.toBytes((String)"version");
    private static final byte[] RULES = Bytes.toBytes((String)"rules");

    public RulesDB(Table rulebook, Table rules, MessagePublisher publisher) {
        this.rulebook = rulebook;
        this.rules = rules;
        this.publisher = publisher;
    }

    public void createRule(RuleRequest rule) throws RuleAlreadyExistsException {
        Row row = this.rules.get(this.toKey(rule.getId()));
        if (!row.isEmpty()) {
            throw new RuleAlreadyExistsException(String.format("Rule '%s' already exists in the rules database. Delete it first or use PUT.", rule.getId()));
        }
        if (rule.getId() == null || rule.getId().trim().isEmpty()) {
            throw new IllegalArgumentException("Rule requires a mandatory field 'id'.");
        }
        if (rule.getDescription() == null || rule.getDescription().trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' requires the mandatory field 'description'", rule.getId()));
        }
        if (rule.getWhen() == null || rule.getWhen().trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' requires mandatory field 'when'", rule.getId()));
        }
        if (rule.getThen() == null || rule.getWhen().trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' requires the mandatory field 'then'", rule.getId()));
        }
        byte[][] columns = new byte[][]{ID, DESCRIPTION, CONDITION, ACTION, CREATED, UPDATED};
        byte[][] values = new byte[][]{this.toKey(rule.getId()), Bytes.toBytes((String)rule.getDescription()), Bytes.toBytes((String)rule.getWhen()), Bytes.toBytes((String)rule.getThen()), Bytes.toBytes((long)this.getCurrentTime()), Bytes.toBytes((long)this.getCurrentTime())};
        this.rules.put(this.toKey(rule.getId()), (byte[][])columns, (byte[][])values);
    }

    public void updateRule(String id, RuleRequest rule) throws RuleNotFoundException {
        Row row = this.rules.get(this.toKey(id));
        if (row.isEmpty()) {
            throw new RuleNotFoundException(String.format("Rule '%s' does not exist. Create it first with a POST request.", rule.getId()));
        }
        if (rule.getDescription() == null || rule.getDescription().trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' requires the mandatory field 'description'", rule.getId()));
        }
        if (rule.getWhen() == null || rule.getWhen().trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' requires mandatory field 'when'", rule.getId()));
        }
        if (rule.getThen() == null || rule.getWhen().trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("Rule '%s' requires the mandatory field 'then'", rule.getId()));
        }
        byte[][] columns = new byte[][]{DESCRIPTION, CONDITION, ACTION, UPDATED};
        byte[][] values = new byte[][]{Bytes.toBytes((String)rule.getDescription()), Bytes.toBytes((String)rule.getWhen()), Bytes.toBytes((String)rule.getThen()), Bytes.toBytes((long)this.getCurrentTime())};
        this.rules.put(this.toKey(id), (byte[][])columns, (byte[][])values);
    }

    public Map<String, Object> retrieveRule(String id) throws RuleNotFoundException {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        Row row = this.rules.get(this.toKey(id));
        if (row.isEmpty()) {
            throw new RuleNotFoundException(String.format("Rule '%s' does not exist. Create it first with a POST request.", id));
        }
        result.put(Bytes.toString((byte[])ID), row.getString(ID));
        result.put(Bytes.toString((byte[])DESCRIPTION), row.getString(DESCRIPTION));
        result.put(Bytes.toString((byte[])CONDITION), row.getString(CONDITION));
        result.put(Bytes.toString((byte[])CREATED), row.getLong(CREATED));
        result.put(Bytes.toString((byte[])UPDATED), row.getLong(UPDATED));
        String then = row.getString(ACTION);
        ArrayList<String> thens = new ArrayList<String>();
        for (String t : then.split(";")) {
            thens.add(t);
        }
        result.put(Bytes.toString((byte[])ACTION), thens);
        return result;
    }

    public void deleteRule(String id) throws RuleNotFoundException {
        Row row = this.rules.get(this.toKey(id));
        if (row.isEmpty()) {
            throw new RuleNotFoundException(String.format("Rule '%s' does not exist. Create it first with a POST request.", id));
        }
        this.rules.delete(this.toKey(id));
    }

    public String retrieveUsingRuleTemplate(String id) throws RuleNotFoundException {
        Row row = this.rules.get(this.toKey(id));
        if (row.isEmpty()) {
            throw new RuleNotFoundException(String.format("Rule '%s' does not exist. Create it first with a POST request.", id));
        }
        return String.format(RULE_TEMPLATE, row.getString(ID), row.getString(DESCRIPTION), row.getString(CONDITION), row.getString(ACTION));
    }

    public void createRulebook(RulebookRequest rb) throws RulebookAlreadyExistsException, RuleNotFoundException {
        Row row = this.rulebook.get(this.toKey(rb.getId()));
        if (!row.isEmpty()) {
            throw new RulebookAlreadyExistsException(String.format("Rulebook '%s' already exists. Either update it or delete it and create it.", rb.getId()));
        }
        for (String rule : rb.getRules()) {
            if (!this.rules.get(this.toKey(rule)).isEmpty()) continue;
            throw new RuleNotFoundException(String.format("Rulebook '%s' includes a rule '%s' that does not exist. Please add rule first", rb.getId(), rule));
        }
        byte[][] columns = new byte[][]{ID, DESCRIPTION, CREATED, UPDATED, USER, SOURCE, VERSION, RULES};
        byte[][] values = new byte[][]{Bytes.toBytes((String)rb.getId()), Bytes.toBytes((String)rb.getDescription()), Bytes.toBytes((long)this.getCurrentTime()), Bytes.toBytes((long)this.getCurrentTime()), Bytes.toBytes((String)rb.getUser()), Bytes.toBytes((String)rb.getSource()), Bytes.toBytes((long)1L), Bytes.toBytes((String)rb.getRulesString())};
        this.rulebook.put(this.toKey(rb.getId()), (byte[][])columns, (byte[][])values);
    }

    public void createRulebook(Rulebook rulebook) throws RulebookAlreadyExistsException {
        ArrayList<String> ruleIds = new ArrayList<String>();
        for (Rule rule : rulebook.getRules()) {
            RuleRequest request = new RuleRequest(rule.getName(), rule.getDescription(), rule.getWhen(), rule.getThen());
            ruleIds.add(rule.getName());
            try {
                this.createRule(request);
            }
            catch (RuleAlreadyExistsException ruleAlreadyExistsException) {}
        }
        RulebookRequest rbreq = new RulebookRequest(rulebook.getName(), rulebook.getMeta().getDescription(), rulebook.getMeta().getSource(), rulebook.getMeta().getUser(), ruleIds);
        try {
            this.createRulebook(rbreq);
        }
        catch (RuleNotFoundException ruleNotFoundException) {
            // empty catch block
        }
    }

    public void updateRulebook(String id, RulebookRequest rb) throws RulebookAlreadyExistsException, RuleNotFoundException {
        Row row = this.rulebook.get(this.toKey(id));
        if (row.isEmpty()) {
            throw new RulebookAlreadyExistsException(String.format("Rulebook '%s' does not exist. Create it first with a POST request.", id));
        }
        byte[][] columns = new byte[][]{DESCRIPTION, USER, SOURCE, VERSION, RULES};
        LOG.info("Ordering of rules {}.", (Object)rb.getRulesString());
        long version = row.getLong(VERSION);
        byte[][] values = new byte[][]{Bytes.toBytes((String)rb.getDescription()), Bytes.toBytes((String)rb.getUser()), Bytes.toBytes((String)rb.getSource()), Bytes.toBytes((long)(++version)), Bytes.toBytes((String)rb.getRulesString())};
        this.rulebook.put(this.toKey(rb.getId()), (byte[][])columns, (byte[][])values);
    }

    public void addRuleToRulebook(String rulebookId, String ruleId) throws RuleAlreadyExistsException, RulebookNotFoundException, RuleNotFoundException {
        Row row = this.rulebook.get(this.toKey(rulebookId));
        if (row.isEmpty()) {
            throw new RulebookNotFoundException(String.format("Rulebook '%s' not found.", rulebookId));
        }
        if (this.rules.get(this.toKey(ruleId)).isEmpty()) {
            throw new RuleNotFoundException(String.format("Attempt to add rule '%s' to rulebook '%s' failed as rule doesn't exist in rules database.", rulebookId, ruleId));
        }
        long version = row.getLong(VERSION);
        List<String> rules = this.convertRulesToSet(row.getString(RULES));
        if (rules.contains(ruleId)) {
            throw new RuleAlreadyExistsException(String.format("Rule '%s' already exists in the rulebook '%s'.", ruleId, rulebookId));
        }
        rules.add(ruleId);
        byte[][] columns = new byte[][]{UPDATED, VERSION, RULES};
        byte[][] values = new byte[][]{Bytes.toBytes((long)this.getCurrentTime()), Bytes.toBytes((long)(++version)), Bytes.toBytes((String)Joiner.on((String)",").join(rules))};
        this.rulebook.put(this.toKey(rulebookId), (byte[][])columns, (byte[][])values);
    }

    public void removeRuleFromRulebook(String rulebookId, String ruleId) throws RuleAlreadyExistsException, RulebookNotFoundException, RuleNotFoundException {
        Row row = this.rulebook.get(this.toKey(rulebookId));
        if (row.isEmpty()) {
            throw new RulebookNotFoundException(String.format("Rulebook '%s' not found.", rulebookId));
        }
        if (this.rules.get(this.toKey(ruleId)).isEmpty()) {
            throw new RuleNotFoundException(String.format("Attempt to remove rule '%s' from rulebook '%s' failed as rule doesn't exist in rules database.", rulebookId, ruleId));
        }
        long version = row.getLong(VERSION);
        List<String> rules = this.convertRulesToSet(row.getString(RULES));
        rules.remove(ruleId);
        byte[][] columns = new byte[][]{UPDATED, VERSION, RULES};
        byte[][] values = new byte[][]{Bytes.toBytes((long)this.getCurrentTime()), Bytes.toBytes((long)(++version)), Bytes.toBytes((String)Joiner.on((String)",").join(rules))};
        this.rulebook.put(this.toKey(rulebookId), (byte[][])columns, (byte[][])values);
    }

    public void cloneRulebook(String rulebookId) throws RuleAlreadyExistsException, RulebookNotFoundException, RuleNotFoundException {
        Row row = this.rulebook.get(this.toKey(rulebookId));
        if (row.isEmpty()) {
            throw new RulebookNotFoundException(String.format("Rulebook '%s' not found.", rulebookId));
        }
        int count = 1;
        String clonedRulebookId = String.format("%s_%d", rulebookId, count);
        while (!this.rulebook.get(this.toKey(clonedRulebookId)).isEmpty()) {
            clonedRulebookId = String.format("%s_%d", rulebookId, ++count);
        }
        byte[][] columns = new byte[][]{ID, DESCRIPTION, CREATED, UPDATED, USER, SOURCE, VERSION, RULES};
        byte[][] values = new byte[][]{Bytes.toBytes((String)clonedRulebookId), row.get(DESCRIPTION), Bytes.toBytes((long)this.getCurrentTime()), Bytes.toBytes((long)this.getCurrentTime()), row.get(USER), row.get(SOURCE), Bytes.toBytes((long)1L), row.get(RULES)};
        this.rulebook.put(this.toKey(clonedRulebookId), (byte[][])columns, (byte[][])values);
    }

    public void deleteRulebook(String rulebookId) throws RulebookNotFoundException {
        Row row = this.rulebook.get(this.toKey(rulebookId));
        if (row.isEmpty()) {
            throw new RulebookNotFoundException(String.format("Rulebook '%s' not found.", rulebookId));
        }
        this.rulebook.delete(this.toKey(rulebookId));
    }

    public JsonArray getRulebookRules(String rulebookId) throws RulebookNotFoundException, RuleNotFoundException {
        Row row = this.rulebook.get(this.toKey(rulebookId));
        if (row.isEmpty()) {
            throw new RulebookNotFoundException(String.format("Rulebook '%s' not found.", rulebookId));
        }
        List<String> ruleSet = this.convertRulesToSet(row.getString(RULES));
        JsonArray array = new JsonArray();
        for (String rule : ruleSet) {
            JsonObject object = new JsonObject();
            Row ruleRow = this.rules.get(this.toKey(rule));
            if (ruleRow.isEmpty()) continue;
            object.addProperty(Bytes.toString((byte[])ID), ruleRow.getString(ID));
            object.addProperty(Bytes.toString((byte[])DESCRIPTION), ruleRow.getString(DESCRIPTION));
            object.addProperty(Bytes.toString((byte[])CONDITION), ruleRow.getString(CONDITION));
            object.addProperty(Bytes.toString((byte[])CREATED), (Number)ruleRow.getLong(CREATED));
            object.addProperty(Bytes.toString((byte[])UPDATED), (Number)ruleRow.getLong(UPDATED));
            JsonArray actions = new JsonArray();
            String then = ruleRow.getString(ACTION);
            if (then != null) {
                for (String t : then.split(";")) {
                    actions.add((JsonElement)new JsonPrimitive(t));
                }
                object.add(Bytes.toString((byte[])ACTION), (JsonElement)actions);
            }
            array.add((JsonElement)object);
        }
        return array;
    }

    public String generateRulebook(String rulebookId) throws RulebookNotFoundException, RuleNotFoundException {
        Row row = this.rulebook.get(this.toKey(rulebookId));
        if (row.isEmpty()) {
            throw new RulebookNotFoundException(String.format("Rulebook '%s' not found.", rulebookId));
        }
        List<String> ruleSet = this.convertRulesToSet(row.getString(RULES));
        ArrayList<String> ruleOutput = new ArrayList<String>();
        for (String rule : ruleSet) {
            Row ruleRow = this.rules.get(this.toKey(rule));
            if (ruleRow.isEmpty()) {
                throw new RuleNotFoundException(String.format("Rulebook '%s' contains rule '%s', but rule '%s' is not present in rules database.", rulebookId, rule, rule));
            }
            ruleOutput.add(String.format(RULE_TEMPLATE, ruleRow.getString(ID), ruleRow.getString(DESCRIPTION), ruleRow.getString(CONDITION), ruleRow.getString(ACTION)));
        }
        String format = String.format(RULEBOOK_TEMPLATE, row.getString(ID), row.getLong(VERSION), row.getString(DESCRIPTION), row.getLong(CREATED), row.getLong(UPDATED), row.getString(SOURCE), row.getString(USER), Joiner.on((String)"").join(ruleOutput));
        return format;
    }

    public List<Map<String, Object>> rules() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (Scanner scan = this.rules.scan(null, null);){
            Row next;
            while ((next = scan.next()) != null) {
                HashMap<String, Object> object = new HashMap<String, Object>();
                object.put(Bytes.toString((byte[])ID), next.getString(ID));
                object.put(Bytes.toString((byte[])DESCRIPTION), next.getString(DESCRIPTION));
                object.put(Bytes.toString((byte[])CONDITION), next.getString(CONDITION));
                object.put(Bytes.toString((byte[])ACTION), next.getString(ACTION));
                object.put(Bytes.toString((byte[])CREATED), next.getLong(CREATED));
                object.put(Bytes.toString((byte[])UPDATED), next.getLong(UPDATED));
                result.add(object);
            }
        }
        return result;
    }

    public List<Map<String, Object>> rulebooks() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try (Scanner scan = this.rulebook.scan(null, null);){
            Row next;
            while ((next = scan.next()) != null) {
                HashMap<String, Object> object = new HashMap<String, Object>();
                object.put(Bytes.toString((byte[])ID), next.getString(ID));
                object.put(Bytes.toString((byte[])DESCRIPTION), next.getString(DESCRIPTION));
                object.put(Bytes.toString((byte[])USER), next.getString(USER));
                object.put(Bytes.toString((byte[])SOURCE), next.getString(SOURCE));
                object.put(Bytes.toString((byte[])VERSION), next.getLong(VERSION));
                object.put(Bytes.toString((byte[])RULES), next.getString(RULES));
                object.put(Bytes.toString((byte[])CREATED), next.getLong(CREATED));
                object.put(Bytes.toString((byte[])UPDATED), next.getLong(UPDATED));
                result.add(object);
            }
        }
        return result;
    }

    private long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    private List<String> convertRulesToSet(String rules) {
        String[] rulesArray;
        ArrayList<String> ruleSet = new ArrayList<String>();
        if (rules == null || rules.trim().isEmpty()) {
            return ruleSet;
        }
        for (String rule : rulesArray = rules.split(",")) {
            ruleSet.add(rule);
        }
        return ruleSet;
    }

    private byte[] toKey(String value) {
        return Bytes.toBytes((String)value);
    }
}

