/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cdap.re.Rule;
import io.cdap.re.RulebookMeta;
import java.util.ArrayList;
import java.util.List;

public final class Rulebook {
    private String name;
    private long version;
    private RulebookMeta meta;
    private List<Rule> rules;

    private Rulebook(String name, RulebookMeta meta, long version, List<Rule> rules) {
        this.name = name;
        this.meta = meta;
        this.version = version;
        this.rules = rules;
    }

    public String getName() {
        return this.name;
    }

    public RulebookMeta getMeta() {
        return this.meta;
    }

    public long getVersion() {
        return this.version;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("name", this.name);
        object.addProperty("version", (Number)this.version);
        object.add("meta", this.meta.toJson());
        JsonArray array = new JsonArray();
        for (Rule rule : this.rules) {
            array.add(rule.toJson());
        }
        object.add("rules", (JsonElement)array);
        return object;
    }

    public Builder builder(String name) {
        return new Builder(name);
    }

    public static final class Builder {
        private String name;
        private long version;
        private String rbDescription;
        private long created;
        private long updated;
        private String source;
        private String user;
        private List<Rule> rules;

        public Builder(String name) {
            this.name = name;
            this.rules = new ArrayList<Rule>();
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder description(String description) {
            this.rbDescription = description;
            return this;
        }

        public Builder created(long created) {
            this.created = created;
            return this;
        }

        public Builder updated(long updated) {
            this.updated = updated;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder addRule(Rule rule) {
            this.rules.add(rule);
            return this;
        }

        public Rulebook build() {
            if (this.created == 0L) {
                this.created = System.currentTimeMillis() / 1000L;
            }
            if (this.updated == 0L) {
                this.updated = this.created;
            }
            if (this.source == null || this.source.isEmpty()) {
                this.source = "not defined";
            }
            if (this.user == null || this.user.isEmpty()) {
                this.user = "";
            }
            RulebookMeta meta = new RulebookMeta(this.rbDescription, this.created, this.updated, this.source, this.user);
            return new Rulebook(this.name, meta, this.version, this.rules);
        }
    }
}

