/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import io.cdap.re.InferenceEngine;
import io.cdap.re.RowActiveSet;
import io.cdap.re.Rule;
import io.cdap.re.RuleCompileException;
import io.cdap.re.RuleExecutor;
import io.cdap.re.Rulebook;
import io.cdap.re.SkipRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.RecipeException;
import io.cdap.wrangler.api.Row;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleInferenceEngine
implements InferenceEngine {
    private static final Logger LOG = LoggerFactory.getLogger(RuleInferenceEngine.class);
    private final Rulebook rulebook;
    private final List<RuleExecutor> ruleset;
    private final Set<String> executed = new HashSet<String>();
    private final ExecutorContext executorContext;

    public RuleInferenceEngine(Rulebook rulebook, ExecutorContext executorContext) {
        this.rulebook = rulebook;
        this.executorContext = executorContext;
        this.ruleset = new ArrayList<RuleExecutor>();
    }

    @Override
    public void initialize() throws RuleCompileException {
        LOG.info("Applying rulebook '{}', version '{}' to incoming records.", (Object)this.rulebook.getName(), (Object)this.rulebook.getVersion());
        for (Rule rule : this.rulebook.getRules()) {
            RuleExecutor ruleExecutor = new RuleExecutor(rule, this.executorContext);
            this.ruleset.add(ruleExecutor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row infer(Row row) throws RecipeException, SkipRowException {
        List<RuleExecutor> workingSet = this.ruleset;
        RowActiveSet rowSet = new RowActiveSet(row);
        this.executed.clear();
        while (workingSet.size() > 0) {
            ArrayList<RuleExecutor> selected = new ArrayList<RuleExecutor>();
            ArrayList<RuleExecutor> unselected = new ArrayList<RuleExecutor>();
            for (RuleExecutor executable : workingSet) {
                if (executable.shouldExecute(rowSet) && executable.when(rowSet) && !this.executed.contains(executable.getRule().getName())) {
                    this.registerMetric(executable);
                    selected.add(executable);
                    continue;
                }
                unselected.add(executable);
            }
            if (workingSet.size() == unselected.size()) {
                return row;
            }
            for (RuleExecutor rule : selected) {
                try {
                    row = rule.then(rowSet.get());
                    if (row == null) continue;
                    rowSet.set(row);
                }
                finally {
                    this.executed.add(rule.getRule().getName());
                }
            }
            workingSet = unselected;
        }
        return row;
    }

    private void registerMetric(RuleExecutor executor) {
        String metricName = String.format("%s.%s.%s.fired", this.rulebook.getName(), this.rulebook.getVersion(), executor.getRule().getName());
        if (this.executorContext != null) {
            this.executorContext.getMetrics().pipelineCount(metricName, 1);
            this.executorContext.getMetrics().pipelineCount(executor.getRule().getName() + ".fired", 1);
            this.executorContext.getMetrics().pipelineCount(this.rulebook.getName() + "." + executor.getRule().getName() + ".fired", 1);
        }
    }

    @Override
    public void destroy() {
    }
}

