/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import org.apache.commons.lang3.StringUtils;

public class RuleFunctions {
    public static final int UNI_SUR_HIGH_START = 55296;
    public static final int UNI_SUR_HIGH_END = 56319;
    public static final int UNI_SUR_LOW_START = 56320;
    public static final int UNI_SUR_LOW_END = 57343;

    public static boolean present(Object value) {
        return value != null;
    }

    public static boolean has(Object field) {
        return field != null;
    }

    public static boolean isnull(Object value) {
        return !RuleFunctions.has(value);
    }

    public static boolean ishex(char c) {
        return c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static boolean isnullorempty(String value) {
        if (value == null) {
            return true;
        }
        return value.trim().isEmpty();
    }

    public static boolean contains(CharSequence seq, int searchChar) {
        return StringUtils.contains((CharSequence)seq, (int)searchChar);
    }

    public static boolean contains(CharSequence seq, CharSequence searchSeq) {
        return StringUtils.contains((CharSequence)seq, (CharSequence)searchSeq);
    }

    public static boolean containsignorecase(CharSequence str, CharSequence searchStr) {
        return StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)searchStr);
    }

    public static boolean whitespace(CharSequence seq) {
        return StringUtils.containsWhitespace((CharSequence)seq);
    }

    public static boolean any(CharSequence cs, CharSequence searchChars) {
        return StringUtils.containsAny((CharSequence)cs, (CharSequence)searchChars);
    }

    public static boolean any(CharSequence cs, CharSequence ... searchCharSequences) {
        return StringUtils.containsAny((CharSequence)cs, (CharSequence[])searchCharSequences);
    }

    public static boolean only(CharSequence cs, char ... valid) {
        return StringUtils.containsOnly((CharSequence)cs, (char[])valid);
    }

    public static boolean only(CharSequence cs, String validChars) {
        return StringUtils.containsOnly((CharSequence)cs, (String)validChars);
    }

    public static boolean none(CharSequence cs, char ... searchChars) {
        return StringUtils.containsNone((CharSequence)cs, (char[])searchChars);
    }

    public static boolean none(CharSequence cs, String invalidChars) {
        return StringUtils.containsNone((CharSequence)cs, (String)invalidChars);
    }

    public static boolean isalpha(CharSequence cs) {
        return StringUtils.isAlpha((CharSequence)cs);
    }

    public static boolean isalphaspace(CharSequence cs) {
        return StringUtils.isAlphaSpace((CharSequence)cs);
    }

    public static boolean isalphanumeric(CharSequence cs) {
        return StringUtils.isAlphanumeric((CharSequence)cs);
    }

    public static boolean isalphanumericspace(CharSequence cs) {
        return StringUtils.isAlphanumericSpace((CharSequence)cs);
    }

    public static boolean isprintable(CharSequence cs) {
        return StringUtils.isAsciiPrintable((CharSequence)cs);
    }

    public static boolean iswhitespace(CharSequence cs) {
        return StringUtils.isWhitespace((CharSequence)cs);
    }

    public static boolean isalllower(CharSequence cs) {
        return StringUtils.isAllLowerCase((CharSequence)cs);
    }

    public static boolean isallupper(CharSequence cs) {
        return StringUtils.isAllUpperCase((CharSequence)cs);
    }

    public static boolean startswith(CharSequence str, CharSequence prefix) {
        return StringUtils.startsWith((CharSequence)str, (CharSequence)prefix);
    }

    public static boolean startswithnocase(CharSequence str, CharSequence prefix) {
        return StringUtils.startsWithIgnoreCase((CharSequence)str, (CharSequence)prefix);
    }

    public static boolean startswithany(CharSequence sequence, CharSequence ... searchStrings) {
        return StringUtils.startsWithAny((CharSequence)sequence, (CharSequence[])searchStrings);
    }

    public static boolean endswith(CharSequence str, CharSequence suffix) {
        return StringUtils.endsWith((CharSequence)str, (CharSequence)suffix);
    }

    public static boolean endswithnocase(CharSequence str, CharSequence suffix) {
        return StringUtils.endsWithIgnoreCase((CharSequence)str, (CharSequence)suffix);
    }

    public static boolean endswithany(CharSequence sequence, CharSequence ... searchStrings) {
        return StringUtils.endsWithAny((CharSequence)sequence, (CharSequence[])searchStrings);
    }

    public static boolean isUTF16String(CharSequence s) {
        int size = s.length();
        for (int i = 0; i < size; ++i) {
            char ch = s.charAt(i);
            if (ch >= '\ud800' && ch <= '\udbff') {
                if (i < size - 1) {
                    char nextCH;
                    if ((nextCH = s.charAt(++i)) >= '\udc00' && nextCH <= '\udfff') continue;
                    return false;
                }
                return false;
            }
            if (ch < '\udc00' || ch > '\udfff') continue;
            return false;
        }
        return true;
    }
}

