/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;

public final class Rule {
    private String name;
    private String description;
    private List<String> given;
    private String when;
    private List<String> then;

    private Rule(String name, String description, List<String> given, String when, List<String> then) {
        this.name = name;
        this.description = description;
        this.given = given;
        this.when = when;
        this.then = then;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getGiven() {
        return this.given;
    }

    public String getWhen() {
        return this.when;
    }

    public List<String> getThen() {
        return this.then;
    }

    public String getDescription() {
        return this.description;
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("name", this.name);
        object.addProperty("description", this.description);
        object.addProperty("when", this.when);
        JsonArray thens = new JsonArray();
        for (String t : this.then) {
            thens.add((JsonElement)new JsonPrimitive(t));
        }
        object.add("then", (JsonElement)thens);
        JsonArray givens = new JsonArray();
        for (String g : this.given) {
            givens.add((JsonElement)new JsonPrimitive(g));
        }
        object.add("given", (JsonElement)givens);
        return object;
    }

    public static final class Builder {
        private String name;
        private String description;
        private String when;
        private List<String> then;
        private List<String> given;

        public Builder(String name) {
            this.name = name;
            this.then = new ArrayList<String>();
            this.given = new ArrayList<String>();
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder when(String when) {
            this.when = when;
            return this;
        }

        public Builder then(String then) {
            this.then.add(then);
            return this;
        }

        public Builder given(String given) {
            this.given.add(given);
            return this;
        }

        public Rule build() {
            if (this.description == null || this.description.isEmpty()) {
                this.description = "No rule description";
            }
            if (this.when == null || this.when.isEmpty()) {
                throw new IllegalArgumentException(String.format("Rule '%s' has no 'when' clause specified.", this.name));
            }
            if (this.then.size() == 0) {
                throw new IllegalArgumentException(String.format("Rule '%s' has not specified any 'then' clauses", this.name));
            }
            return new Rule(this.name, this.description, this.given, this.when, this.then);
        }
    }
}

