/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import io.cdap.cdap.api.service.http.HttpServiceRequest;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class RequestExtractor {
    private final HttpServiceRequest request;
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHARSET = "charset";

    public RequestExtractor(HttpServiceRequest request) {
        this.request = request;
    }

    public boolean hasHeader(String name) {
        String header = this.request.getHeader(name);
        return header != null;
    }

    public <T> T getHeader(String name, String defaultValue) {
        String header = this.request.getHeader(name);
        return (T)(header == null ? defaultValue : header);
    }

    public byte[] getContent() {
        ByteBuffer content = this.request.getContent();
        if (content != null && content.hasRemaining()) {
            byte[] bytes = new byte[content.remaining()];
            content.get(bytes);
            return bytes;
        }
        return null;
    }

    public String getContent(Charset charset) {
        ByteBuffer content = this.request.getContent();
        if (content != null && content.hasRemaining()) {
            return charset.decode(content).toString();
        }
        return null;
    }

    public String getContent(String charset) {
        return this.getContent(Charset.forName(charset));
    }

    public boolean isContentType(String expectedType) {
        if (this.hasHeader(CONTENT_TYPE)) {
            String header = (String)this.getHeader(CONTENT_TYPE, null);
            return header == null || header.equalsIgnoreCase(expectedType);
        }
        return false;
    }
}

