/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import io.cdap.cdap.etl.api.Lookup;
import io.cdap.cdap.etl.api.StageMetrics;
import io.cdap.cdap.etl.api.TransformContext;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.TransientStore;
import java.net.URL;
import java.util.Map;

class RulesEngineContext
implements ExecutorContext {
    private final ExecutorContext.Environment environment;
    private final TransformContext context;
    private final TransientStore store;
    private final StageMetrics metrics;
    private final String namespace;
    private final String name;
    private final Map<String, String> properties;

    RulesEngineContext(ExecutorContext.Environment environment, TransformContext context, TransientStore store) {
        this.environment = environment;
        this.namespace = context.getNamespace();
        this.metrics = context.getMetrics();
        this.name = context.getStageName();
        this.properties = context.getPluginProperties().getProperties();
        this.context = context;
        this.store = store;
    }

    public ExecutorContext.Environment getEnvironment() {
        return this.environment;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public StageMetrics getMetrics() {
        return this.metrics;
    }

    public String getContextName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public URL getService(String applicationId, String serviceId) {
        return this.context.getServiceURL(applicationId, serviceId);
    }

    public TransientStore getTransientStore() {
        return this.store;
    }

    public <T> Lookup<T> provide(String s, Map<String, String> map) {
        return this.context.provide(s, map);
    }
}

