/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.Emitter;
import io.cdap.cdap.etl.api.InvalidEntry;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.Transform;
import io.cdap.cdap.etl.api.TransformContext;
import io.cdap.directives.aggregates.DefaultTransientStore;
import io.cdap.re.InferenceEngine;
import io.cdap.re.RuleInferenceEngine;
import io.cdap.re.Rulebook;
import io.cdap.re.RulebookCompiler;
import io.cdap.re.RulesEngineContext;
import io.cdap.re.SkipRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.TransientStore;
import io.cdap.wrangler.utils.RecordConvertor;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="transform")
@Name(value="RulesEngine")
@Description(value="A Rule Engine that uses Inference to determines the fields to process in a record")
public final class RulesEngine
extends Transform<StructuredRecord, StructuredRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(RulesEngine.class);
    private final Config config;
    private InferenceEngine ie;
    private TransientStore store;
    private Schema oSchema = null;
    private Rulebook rulebook;
    private final RecordConvertor convertor = new RecordConvertor();
    private final List<Row> rows = new ArrayList<Row>();

    public RulesEngine(Config config) {
        this.config = config;
    }

    public void configurePipeline(PipelineConfigurer configurer) throws IllegalArgumentException {
        super.configurePipeline(configurer);
        try {
            if (!this.config.containsMacro("rulebook")) {
                StringReader reader = new StringReader(this.config.rulebook);
                RulebookCompiler compiler = new RulebookCompiler();
                this.rulebook = compiler.compile(reader);
                RuleInferenceEngine ie = new RuleInferenceEngine(this.rulebook, null);
                ie.initialize();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            if (!this.config.containsMacro("schema")) {
                this.oSchema = Schema.parseJson((String)this.config.schema);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Format of output schema specified is invalid. Please check the format.");
        }
        if (this.oSchema != null) {
            configurer.getStageConfigurer().setOutputSchema(this.oSchema);
        }
    }

    public void initialize(TransformContext context) throws Exception {
        super.initialize(context);
        this.store = new DefaultTransientStore();
        try {
            this.oSchema = Schema.parseJson((String)this.config.schema);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Stage:%s - Format of output schema specified is invalid. Please check the format.", context.getStageName()));
        }
        StringReader reader = new StringReader(this.config.rulebook);
        RulebookCompiler compiler = new RulebookCompiler();
        this.rulebook = compiler.compile(reader);
        RulesEngineContext ctx = new RulesEngineContext(ExecutorContext.Environment.TRANSFORM, context, this.store);
        this.ie = new RuleInferenceEngine(this.rulebook, ctx);
        this.ie.initialize();
    }

    public void transform(StructuredRecord input, Emitter<StructuredRecord> emitter) throws Exception {
        Row row = new Row();
        for (Object field : input.getSchema().getFields()) {
            row.add(field.getName(), input.get(field.getName()));
        }
        try {
            this.rows.clear();
            row = this.ie.infer(row);
            if (row != null) {
                this.rows.add(row);
                List records = this.convertor.toStructureRecord(this.rows, this.oSchema);
                for (StructuredRecord record : records) {
                    StructuredRecord.Builder builder = StructuredRecord.builder((Schema)this.oSchema);
                    for (Schema.Field field : this.oSchema.getFields()) {
                        Object wObject = record.get(field.getName());
                        if (wObject == null) {
                            builder.set(field.getName(), null);
                            continue;
                        }
                        if (wObject instanceof String) {
                            builder.convertAndSet(field.getName(), (String)wObject);
                            continue;
                        }
                        builder.set(field.getName(), wObject);
                    }
                    emitter.emit((Object)builder.build());
                }
            }
        }
        catch (SkipRowException e) {
            String message = String.format("Fired rulebook '%s', version '%s', rule name '%s', description '%s', condition {%s}.", this.rulebook.getName(), this.rulebook.getVersion(), e.getRule().getName(), e.getRule().getDescription(), e.getRule().getWhen());
            emitter.emitError(new InvalidEntry(100, message, (Object)input));
        }
    }

    public static class Config
    extends PluginConfig {
        @Name(value="rulebook")
        @Description(value="Specify the rule book.")
        @Macro
        private String rulebook;
        @Name(value="schema")
        @Description(value="Specifies the schema that has to be output.")
        @Macro
        private final String schema;
        @Name(value="rulebookid")
        @Description(value="Hidden property used only by UI")
        @Nullable
        private String rulebookid;

        public Config(String rulebook, String schema, String rulebookid) {
            this.rulebook = rulebook;
            this.schema = schema;
            this.rulebookid = rulebookid;
        }
    }
}

