/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import io.cdap.re.Compiler;
import io.cdap.re.Rule;
import io.cdap.re.Rulebook;
import io.cdap.re.RulebookASTVisitor;
import io.cdap.re.RulebookCompileException;
import io.cdap.re.SyntaxErrorListener;
import io.cdap.re.parser.RulebookLexer;
import io.cdap.re.parser.RulebookParser;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;

public class RulebookCompiler
implements Compiler {
    private JexlEngine engine = new JexlBuilder().silent(false).cache(0x100000).cacheThreshold(0x100000).strict(true).create();

    @Override
    public Rulebook compile(Reader reader) throws RulebookCompileException {
        try {
            SyntaxErrorListener error = new SyntaxErrorListener();
            CodePointCharStream stream = CharStreams.fromReader((Reader)reader);
            RulebookLexer lexer = new RulebookLexer((CharStream)stream);
            lexer.removeErrorListeners();
            RulebookParser parser = new RulebookParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)error);
            parser.setBuildParseTree(true);
            RulebookParser.RulebookContext ast = parser.rulebook();
            if (error.hasErrors()) {
                throw new RulebookCompileException("Error parsing rulebook, please check the rulebook syntax.", error.iterator());
            }
            RulebookASTVisitor visitor = new RulebookASTVisitor();
            visitor.visit((ParseTree)ast);
            Rulebook rulebook = visitor.get();
            List<Rule> rules = rulebook.getRules();
            for (Rule rule : rules) {
                try {
                    this.engine.createScript(rule.getWhen());
                }
                catch (JexlException.Variable e) {
                    throw new RulebookCompileException(String.format("%s:%s - Variable '%s' is not defined.", rulebook.getName(), rule.getName(), e.getVariable()));
                }
                catch (JexlException.Parsing e) {
                    throw new RulebookCompileException(String.format("%s:%s - %s", rulebook.getName(), rule.getName(), e.getMessage()));
                }
            }
            return rulebook;
        }
        catch (IOException e) {
            throw new RulebookCompileException(e.getMessage());
        }
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable.getCause() != null) {
            return RulebookCompiler.getRootCause(throwable.getCause());
        }
        return throwable;
    }
}

