/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.re.RowActiveSet;
import io.cdap.re.Rule;
import io.cdap.re.RuleCompileException;
import io.cdap.re.RuleFunctions;
import io.cdap.re.SkipRowException;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.api.DirectiveNotFoundException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.RecipeException;
import io.cdap.wrangler.api.RecipeParser;
import io.cdap.wrangler.api.RecipePipeline;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.executor.RecipePipelineExecutor;
import io.cdap.wrangler.parser.GrammarBasedParser;
import io.cdap.wrangler.parser.MigrateToV2;
import io.cdap.wrangler.registry.CompositeDirectiveRegistry;
import io.cdap.wrangler.registry.DirectiveRegistry;
import io.cdap.wrangler.registry.SystemDirectiveRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RuleExecutor.class);
    private static final JexlEngine engine = new JexlBuilder().namespaces(RuleExecutor.getRegisteredFunctions()).silent(false).cache(0x100000).cacheThreshold(0x100000).silent(true).strict(false).debug(false).create();
    private Rule rule;
    private JexlScript script;
    private List<String> variables = new ArrayList<String>();
    private RecipePipeline pipeline;
    private ExecutorContext context;

    public RuleExecutor(Rule rule, ExecutorContext context) throws RuleCompileException {
        try {
            this.script = engine.createScript(rule.getWhen());
            for (List vars : this.script.getVariables()) {
                for (String var : vars) {
                    this.variables.add(var);
                }
            }
            this.rule = rule;
            this.context = context;
            this.pipeline = this.compile(rule.getThen());
        }
        catch (Exception e) {
            throw new RuleCompileException(e.getMessage(), rule);
        }
    }

    public boolean validateWhen(String when) throws JexlException {
        engine.createScript(when);
        return true;
    }

    public boolean validateThen(String then) throws Exception {
        this.compile(Arrays.asList(then.split(";")));
        return true;
    }

    public boolean shouldExecute(RowActiveSet set) {
        if (this.variables.size() == 0) {
            return true;
        }
        for (String variable : this.variables) {
            if (set.has(variable)) continue;
            return false;
        }
        return true;
    }

    public boolean when(RowActiveSet set) {
        Object object = this.script.execute((JexlContext)set);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return true;
    }

    public Row then(Row row) throws RecipeException, SkipRowException {
        List result = this.pipeline.execute(Arrays.asList(row));
        List errors = this.pipeline.errors();
        if (errors.size() > 0) {
            throw new SkipRowException(this.rule);
        }
        if (result.size() > 0) {
            return (Row)result.get(0);
        }
        return null;
    }

    public Rule getRule() {
        return this.rule;
    }

    public static Map<String, Object> getRegisteredFunctions() {
        HashMap<String, Object> functions = new HashMap<String, Object>();
        functions.put(null, RuleFunctions.class);
        functions.put("math", Math.class);
        functions.put("string", StringUtils.class);
        functions.put("bytes", Bytes.class);
        functions.put("arrays", Arrays.class);
        return functions;
    }

    public RecipePipeline compile(List<String> recipe) throws RecipeException, DirectiveParseException, DirectiveLoadException, DirectiveNotFoundException {
        CompositeDirectiveRegistry registry = new CompositeDirectiveRegistry(new DirectiveRegistry[]{new SystemDirectiveRegistry()});
        String migrate = new MigrateToV2(recipe).migrate();
        GrammarBasedParser parser = new GrammarBasedParser(this.context == null ? "system" : this.context.getNamespace(), migrate, (DirectiveRegistry)registry);
        parser.initialize(null);
        RecipePipelineExecutor pipeline = new RecipePipelineExecutor();
        pipeline.initialize((RecipeParser)parser, this.context);
        return pipeline;
    }
}

