/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.test.mock;

import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.plugin.PluginClass;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.api.plugin.PluginPropertyField;
import io.cdap.delta.api.Configurer;
import io.cdap.delta.api.DDLEvent;
import io.cdap.delta.api.DDLOperation;
import io.cdap.delta.api.DMLEvent;
import io.cdap.delta.api.DeltaFailureException;
import io.cdap.delta.api.DeltaTarget;
import io.cdap.delta.api.DeltaTargetContext;
import io.cdap.delta.api.EventConsumer;
import io.cdap.delta.api.ReplicationError;
import io.cdap.delta.api.Sequenced;
import io.cdap.delta.api.assessment.StandardizedTableDetail;
import io.cdap.delta.api.assessment.TableAssessment;
import io.cdap.delta.api.assessment.TableAssessor;
import io.cdap.delta.proto.Artifact;
import io.cdap.delta.proto.Plugin;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import javax.annotation.Nullable;

@io.cdap.cdap.api.annotation.Plugin(type="cdcTarget")
@Name(value="failure")
public class FailureTarget
implements DeltaTarget {
    static final String NAME = "failure";
    public static final PluginClass PLUGIN_CLASS = FailureTarget.getPluginClass();
    private final Conf conf;

    public FailureTarget(Conf conf) {
        this.conf = conf;
    }

    public void configure(Configurer configurer) {
    }

    public EventConsumer createConsumer(final DeltaTargetContext context) {
        final File proceedFile = this.conf.proceedFile == null ? null : new File(this.conf.proceedFile);
        return new EventConsumer(){

            public void start() {
            }

            public void stop() {
            }

            public void applyDDL(Sequenced<DDLEvent> event) throws IOException, DeltaFailureException {
                DDLOperation ddlOperation = ((DDLEvent)event.getEvent()).getOperation();
                context.incrementCount(ddlOperation);
                this.throwIfNeeded(event.getSequenceNumber(), ((DDLEvent)event.getEvent()).getOperation().getDatabaseName(), ddlOperation.getTableName());
                context.setTableReplicating(((DDLEvent)event.getEvent()).getOperation().getDatabaseName(), ddlOperation.getTableName());
                context.commitOffset(((DDLEvent)event.getEvent()).getOffset(), event.getSequenceNumber());
            }

            public void applyDML(Sequenced<DMLEvent> event) throws IOException, DeltaFailureException {
                DMLEvent dml = (DMLEvent)event.getEvent();
                context.incrementCount(dml.getOperation());
                this.throwIfNeeded(event.getSequenceNumber(), dml.getOperation().getDatabaseName(), dml.getOperation().getTableName());
                context.setTableReplicating(dml.getOperation().getDatabaseName(), dml.getOperation().getTableName());
                context.commitOffset(dml.getOffset(), event.getSequenceNumber());
            }

            private void throwIfNeeded(long sequenceNum, String database, String table) throws IOException, DeltaFailureException {
                if (!(proceedFile != null && proceedFile.exists() || sequenceNum <= FailureTarget.this.conf.sequenceNumThreshold)) {
                    RuntimeException e = new RuntimeException("Expected target failure for sequence number " + sequenceNum);
                    context.setTableError(database, table, new ReplicationError((Throwable)e));
                    if (FailureTarget.this.conf.failImmediately) {
                        throw new DeltaFailureException(e.getMessage(), (Throwable)e);
                    }
                    throw e;
                }
            }
        };
    }

    public TableAssessor<StandardizedTableDetail> createTableAssessor(Configurer configurer) {
        return tableDetail -> new TableAssessment(Collections.emptyList(), Collections.emptyList());
    }

    public static Plugin failAfter(long sequenceNumThreshold, File proceedFile) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("sequenceNumThreshold", String.valueOf(sequenceNumThreshold));
        properties.put("proceedFile", proceedFile.getAbsolutePath());
        properties.put("failImmediately", String.valueOf(Boolean.FALSE));
        return new Plugin(NAME, "cdcTarget", properties, Artifact.EMPTY);
    }

    public static Plugin failImmediately(long sequenceNumThreshold) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("sequenceNumThreshold", String.valueOf(sequenceNumThreshold));
        properties.put("failImmediately", String.valueOf(Boolean.TRUE));
        return new Plugin(NAME, "cdcTarget", properties, Artifact.EMPTY);
    }

    private static PluginClass getPluginClass() {
        HashMap<String, PluginPropertyField> properties = new HashMap<String, PluginPropertyField>();
        properties.put("sequenceNumThreshold", new PluginPropertyField("sequenceNumThreshold", "", "long", true, false));
        properties.put("proceedFile", new PluginPropertyField("proceedFile", "", "string", false, false));
        properties.put("failImmediately", new PluginPropertyField("failImmediately", "", "boolean", true, false));
        return new PluginClass("cdcTarget", NAME, "", FailureTarget.class.getName(), "conf", properties);
    }

    private static class Conf
    extends PluginConfig {
        private long sequenceNumThreshold;
        @Nullable
        private String proceedFile;
        private boolean failImmediately;

        private Conf() {
        }
    }
}

