/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.test.mock;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.format.StructuredRecordStringConverter;
import java.io.IOException;
import java.lang.reflect.Type;

public class StructuredRecordSerde
implements JsonSerializer<StructuredRecord>,
JsonDeserializer<StructuredRecord> {
    public StructuredRecord deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject obj = jsonElement.getAsJsonObject();
        Schema schema = (Schema)context.deserialize(obj.get("schema"), Schema.class);
        try {
            return StructuredRecordStringConverter.fromJsonString((String)obj.get("record").getAsString(), (Schema)schema);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonElement serialize(StructuredRecord structuredRecord, Type type, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.add("schema", context.serialize((Object)structuredRecord.getSchema(), Schema.class));
        try {
            obj.addProperty("record", StructuredRecordStringConverter.toJsonString((StructuredRecord)structuredRecord));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return obj;
    }
}

