/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.test.mock;

import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.plugin.PluginClass;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.api.plugin.PluginPropertyField;
import io.cdap.delta.api.Configurer;
import io.cdap.delta.api.DeltaTarget;
import io.cdap.delta.api.DeltaTargetContext;
import io.cdap.delta.api.EventConsumer;
import io.cdap.delta.api.assessment.StandardizedTableDetail;
import io.cdap.delta.api.assessment.TableAssessment;
import io.cdap.delta.api.assessment.TableAssessor;
import io.cdap.delta.proto.Artifact;
import io.cdap.delta.proto.Plugin;
import io.cdap.delta.test.mock.FileEventConsumer;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;

@io.cdap.cdap.api.annotation.Plugin(type="cdcTarget")
@Name(value="mock")
public class MockTarget
implements DeltaTarget {
    static final String NAME = "mock";
    public static final PluginClass PLUGIN_CLASS = MockTarget.getPluginClass();
    private final Conf conf;

    public MockTarget(Conf conf) {
        this.conf = conf;
    }

    public void configure(Configurer configurer) {
    }

    public EventConsumer createConsumer(DeltaTargetContext context) {
        File outputFile = new File(new File(this.conf.path), String.format("%d.json", context.getInstanceId()));
        if (outputFile.exists()) {
            outputFile.delete();
        }
        return new FileEventConsumer(outputFile, context);
    }

    public TableAssessor<StandardizedTableDetail> createTableAssessor(Configurer configurer) {
        return tableDetail -> new TableAssessment(Collections.emptyList(), Collections.emptyList());
    }

    public static Plugin getPlugin(File filePath) {
        return new Plugin(NAME, "cdcTarget", Collections.singletonMap("path", filePath.getAbsolutePath()), Artifact.EMPTY);
    }

    private static PluginClass getPluginClass() {
        HashMap<String, PluginPropertyField> properties = new HashMap<String, PluginPropertyField>();
        properties.put("path", new PluginPropertyField("path", "", "string", true, false));
        return new PluginClass("cdcTarget", NAME, "", MockTarget.class.getName(), "conf", properties);
    }

    private static class Conf
    extends PluginConfig {
        private String path;

        private Conf() {
        }
    }
}

