/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.test.mock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginClass;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.api.plugin.PluginPropertyField;
import io.cdap.cdap.internal.io.SchemaTypeAdapter;
import io.cdap.delta.api.ChangeEvent;
import io.cdap.delta.api.Configurer;
import io.cdap.delta.api.DeltaSource;
import io.cdap.delta.api.DeltaSourceContext;
import io.cdap.delta.api.EventEmitter;
import io.cdap.delta.api.EventReader;
import io.cdap.delta.api.EventReaderDefinition;
import io.cdap.delta.api.assessment.StandardizedTableDetail;
import io.cdap.delta.api.assessment.TableAssessor;
import io.cdap.delta.api.assessment.TableDetail;
import io.cdap.delta.api.assessment.TableList;
import io.cdap.delta.api.assessment.TableRegistry;
import io.cdap.delta.proto.Artifact;
import io.cdap.delta.proto.Plugin;
import io.cdap.delta.test.mock.ChangeEventDeserializer;
import io.cdap.delta.test.mock.FailureEventReader;
import io.cdap.delta.test.mock.MockEventReader;
import io.cdap.delta.test.mock.StructuredRecordSerde;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

@io.cdap.cdap.api.annotation.Plugin(type="cdcSource")
@Name(value="mock")
public class MockSource
implements DeltaSource {
    public static final String NAME = "mock";
    public static final PluginClass PLUGIN_CLASS = MockSource.getPluginClass();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(StructuredRecord.class, (Object)new StructuredRecordSerde()).registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).registerTypeAdapter(ChangeEvent.class, (Object)new ChangeEventDeserializer()).create();
    private final Conf conf;

    public MockSource(Conf conf) {
        this.conf = conf;
    }

    public void configure(Configurer configurer) {
    }

    public EventReader createReader(EventReaderDefinition definition, DeltaSourceContext context, EventEmitter emitter) {
        File proceedFile;
        if (this.conf.proceedFile != null && !(proceedFile = new File(this.conf.proceedFile)).exists()) {
            return new FailureEventReader(context);
        }
        try {
            context.setOK();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new MockEventReader((List)GSON.fromJson(this.conf.events, new TypeToken<List<? extends ChangeEvent>>(){}.getType()), emitter, this.conf.maxEvents);
    }

    public TableRegistry createTableRegistry(Configurer configurer) {
        return new TableRegistry(){

            public TableList listTables() {
                return null;
            }

            public TableDetail describeTable(String database, String table) {
                return null;
            }

            public StandardizedTableDetail standardize(TableDetail tableDetail) {
                return null;
            }

            public void close() {
            }
        };
    }

    public TableAssessor<TableDetail> createTableAssessor(Configurer configurer) {
        return tableDescriptor -> null;
    }

    public static Plugin getPlugin(List<? extends ChangeEvent> events) {
        return MockSource.getPlugin(events, events.size());
    }

    public static Plugin getPlugin(List<? extends ChangeEvent> events, int maxEvents) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("events", GSON.toJson(events));
        properties.put("maxEvents", String.valueOf(maxEvents));
        return new Plugin(NAME, "cdcSource", properties, Artifact.EMPTY);
    }

    public static Plugin getPlugin(List<? extends ChangeEvent> events, File proceedFile) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("events", GSON.toJson(events));
        properties.put("maxEvents", String.valueOf(Integer.MAX_VALUE));
        properties.put("proceedFile", proceedFile.getAbsolutePath());
        return new Plugin(NAME, "cdcSource", properties, Artifact.EMPTY);
    }

    private static PluginClass getPluginClass() {
        HashMap<String, PluginPropertyField> properties = new HashMap<String, PluginPropertyField>();
        properties.put("events", new PluginPropertyField("events", "", "string", true, false));
        properties.put("maxEvents", new PluginPropertyField("maxEvents", "", "int", true, false));
        properties.put("proceedFile", new PluginPropertyField("proceedFile", "", "string", false, false));
        return new PluginClass("cdcSource", NAME, "", MockSource.class.getName(), "conf", properties);
    }

    private static class Conf
    extends PluginConfig {
        private String events;
        private int maxEvents;
        @Nullable
        private String proceedFile;

        private Conf() {
        }
    }
}

