/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.test.mock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.internal.io.SchemaTypeAdapter;
import io.cdap.delta.api.ChangeEvent;
import io.cdap.delta.api.DDLEvent;
import io.cdap.delta.api.DMLEvent;
import io.cdap.delta.api.DeltaTargetContext;
import io.cdap.delta.api.EventConsumer;
import io.cdap.delta.api.Sequenced;
import io.cdap.delta.test.mock.ChangeEventDeserializer;
import io.cdap.delta.test.mock.StructuredRecordSerde;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileEventConsumer
implements EventConsumer {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).registerTypeAdapter(StructuredRecord.class, (Object)new StructuredRecordSerde()).registerTypeAdapter(ChangeEvent.class, (Object)new ChangeEventDeserializer()).create();
    private final File file;
    private final List<ChangeEvent> events;
    private final DeltaTargetContext context;

    FileEventConsumer(File file, DeltaTargetContext context) {
        this.file = file;
        this.events = new ArrayList<ChangeEvent>();
        this.context = context;
    }

    public void start() {
    }

    public void stop() {
        try (FileWriter writer = new FileWriter(this.file);){
            writer.write(GSON.toJson(this.events));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void applyDDL(Sequenced<DDLEvent> event) throws IOException {
        this.events.add((ChangeEvent)event.getEvent());
        this.context.incrementCount(((DDLEvent)event.getEvent()).getOperation());
        this.context.commitOffset(((DDLEvent)event.getEvent()).getOffset(), event.getSequenceNumber());
        this.context.setTableReplicating(((DDLEvent)event.getEvent()).getDatabase(), ((DDLEvent)event.getEvent()).getTable());
    }

    public void applyDML(Sequenced<DMLEvent> event) throws IOException {
        this.events.add((ChangeEvent)event.getEvent());
        this.context.incrementCount(((DMLEvent)event.getEvent()).getOperation());
        this.context.commitOffset(((DMLEvent)event.getEvent()).getOffset(), event.getSequenceNumber());
    }

    public static List<? extends ChangeEvent> readEvents(File filePath, int instanceId) throws IOException {
        File eventsFile = new File(filePath, String.format("%d.json", instanceId));
        if (!eventsFile.exists()) {
            return Collections.emptyList();
        }
        try (FileReader reader = new FileReader(eventsFile);){
            List list = (List)GSON.fromJson((Reader)reader, new TypeToken<List<? extends ChangeEvent>>(){}.getType());
            return list;
        }
    }
}

