/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.proto;

import io.cdap.delta.proto.ColumnTransformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TableTransformation {
    private String tableName;
    private List<ColumnTransformation> columnTransformations;

    public TableTransformation(String tableName, List<ColumnTransformation> columnTransformations) {
        this.tableName = tableName;
        this.columnTransformations = Collections.unmodifiableList(new ArrayList<ColumnTransformation>(columnTransformations));
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<ColumnTransformation> getColumnTransformations() {
        return this.columnTransformations == null ? Collections.emptyList() : this.columnTransformations;
    }

    public void validate() {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("Table name of a TableTransformation is null or empty.");
        }
        if (this.columnTransformations != null) {
            for (ColumnTransformation columnTransformation : this.columnTransformations) {
                try {
                    columnTransformation.validate();
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("ColumnTransformations validation failed for table %s. Reason: %s.", this.tableName, e.getMessage()));
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableTransformation that = (TableTransformation)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.columnTransformations, that.columnTransformations);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.columnTransformations);
    }
}

