/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.proto;

import io.cdap.cdap.api.app.ApplicationConfigUpdateAction;
import io.cdap.cdap.api.app.ApplicationUpdateContext;
import io.cdap.cdap.api.artifact.ArtifactId;
import io.cdap.cdap.api.artifact.ArtifactVersionRange;
import io.cdap.delta.proto.Artifact;
import io.cdap.delta.proto.Plugin;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stage {
    private static final Logger LOG = LoggerFactory.getLogger(Stage.class);
    private final String name;
    private final Plugin plugin;

    public Stage(String name, Plugin plugin) {
        this.name = name;
        this.plugin = plugin;
    }

    public String getName() {
        return this.name;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Stage updateStage(ApplicationUpdateContext updateContext) throws Exception {
        Iterator iterator = updateContext.getUpdateActions().iterator();
        if (iterator.hasNext()) {
            ApplicationConfigUpdateAction updateAction = (ApplicationConfigUpdateAction)iterator.next();
            if (updateAction == ApplicationConfigUpdateAction.UPGRADE_ARTIFACT) {
                return new Stage(this.name, this.upgradePlugin(updateContext));
            }
            return this;
        }
        return this;
    }

    private Plugin upgradePlugin(ApplicationUpdateContext updateContext) throws Exception {
        Optional<ArtifactId> newPluginCandidate = updateContext.getPluginArtifacts(this.plugin.getType(), this.plugin.getName(), null).stream().max(Comparator.comparing(ArtifactId::getVersion));
        if (!newPluginCandidate.isPresent()) {
            return this.plugin;
        }
        ArtifactId newPlugin = newPluginCandidate.get();
        String newVersion = this.getUpgradedVersionString(newPlugin);
        if (newVersion == null) {
            return this.plugin;
        }
        Artifact newArtifact = new Artifact(newPlugin.getName(), newVersion, newPlugin.getScope().name());
        return new Plugin(this.plugin.getName(), this.plugin.getType(), this.plugin.getProperties(), newArtifact);
    }

    @Nullable
    private String getUpgradedVersionString(ArtifactId newPlugin) {
        ArtifactVersionRange currentVersionRange;
        try {
            currentVersionRange = ArtifactVersionRange.parse((String)Objects.requireNonNull(this.plugin.getArtifact().getVersion()));
        }
        catch (Exception e) {
            LOG.warn("Issue in parsing version string for plugin {}, ignoring stage {} for upgrade.", new Object[]{this.plugin, this.name, e});
            return null;
        }
        if (currentVersionRange.isExactVersion()) {
            if (currentVersionRange.getLower().compareTo(newPlugin.getVersion()) < 0) {
                return newPlugin.getVersion().getVersion();
            }
            return null;
        }
        if (currentVersionRange.versionIsInRange(newPlugin.getVersion())) {
            return null;
        }
        if (currentVersionRange.getLower().compareTo(newPlugin.getVersion()) > 0) {
            LOG.warn("Error in updating stage {}. Invalid new plugin artifact {} upgrading plugin {}.", new Object[]{this.name, newPlugin, this.plugin});
            return null;
        }
        ArtifactVersionRange newVersionRange = new ArtifactVersionRange(currentVersionRange.getLower(), currentVersionRange.isLowerInclusive(), newPlugin.getVersion(), true);
        return newVersionRange.getVersionString();
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Stage is missing a name.");
        }
        try {
            this.plugin.validate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Stage '%s' is invalid: %s", this.name, e.getMessage()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stage stage = (Stage)o;
        return Objects.equals(this.name, stage.name) && Objects.equals(this.plugin, stage.plugin);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.plugin);
    }
}

