/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.proto;

import io.cdap.delta.proto.Artifact;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class Plugin {
    private final String name;
    private final String type;
    private final Map<String, String> properties;
    private final Artifact artifact;

    public Plugin(String name, String type, Map<String, String> properties, Artifact artifact) {
        this.name = name;
        this.type = type;
        this.properties = properties;
        this.artifact = artifact;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, String> getProperties() {
        return this.properties == null ? Collections.emptyMap() : this.properties;
    }

    public Artifact getArtifact() {
        return this.artifact == null ? Artifact.EMPTY : this.artifact;
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Plugin name is missing.");
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new IllegalArgumentException("Plugin type is missing.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return Objects.equals(this.name, plugin.name) && Objects.equals(this.type, plugin.type) && Objects.equals(this.properties, plugin.properties) && Objects.equals(this.artifact, plugin.artifact);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.properties, this.artifact);
    }
}

