/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.proto;

import io.cdap.delta.proto.InstanceConfig;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ParallelismConfig {
    public static final ParallelismConfig DEFAULT = new ParallelismConfig(1, Collections.emptyList());
    private final Integer numInstances;
    private final List<InstanceConfig> instances;

    public ParallelismConfig(int numInstances) {
        this(numInstances, Collections.emptyList());
    }

    public ParallelismConfig(List<InstanceConfig> instances) {
        this(null, instances);
    }

    private ParallelismConfig(Integer numInstances, List<InstanceConfig> instances) {
        this.numInstances = numInstances;
        this.instances = instances;
    }

    @Nullable
    public Integer getNumInstances() {
        return this.numInstances;
    }

    public List<InstanceConfig> getInstances() {
        return this.instances == null ? Collections.emptyList() : Collections.unmodifiableList(this.instances);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParallelismConfig that = (ParallelismConfig)o;
        return this.numInstances == that.numInstances && Objects.equals(this.getInstances(), that.getInstances());
    }

    public int hashCode() {
        return Objects.hash(this.numInstances, this.instances);
    }
}

