/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.proto;

import io.cdap.cdap.api.Config;
import io.cdap.cdap.api.Resources;
import io.cdap.cdap.api.app.ApplicationUpdateContext;
import io.cdap.delta.api.DDLOperation;
import io.cdap.delta.api.DMLOperation;
import io.cdap.delta.api.SourceTable;
import io.cdap.delta.proto.Connection;
import io.cdap.delta.proto.ParallelismConfig;
import io.cdap.delta.proto.RetryConfig;
import io.cdap.delta.proto.Stage;
import io.cdap.delta.proto.TableTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class DeltaConfig
extends Config {
    private final String description;
    private final List<Stage> stages;
    private final List<Connection> connections;
    private final List<TableTransformation> tableTransformations;
    private final Resources resources;
    private final String offsetBasePath;
    private final List<SourceTable> tables;
    private final Set<DMLOperation.Type> dmlBlacklist;
    private final Set<DDLOperation.Type> ddlBlacklist;
    private final RetryConfig retries;
    private final ParallelismConfig parallelism;
    private final boolean service;

    private DeltaConfig(String description, List<Stage> stages, List<Connection> connections, List<TableTransformation> tableTransformations, Resources resources, String offsetBasePath, List<SourceTable> tables, Set<DMLOperation.Type> dmlBlacklist, Set<DDLOperation.Type> ddlBlacklist, RetryConfig retries, ParallelismConfig parallelism) {
        this.description = description;
        this.stages = new ArrayList<Stage>(stages);
        this.connections = new ArrayList<Connection>(connections);
        this.tableTransformations = new ArrayList<TableTransformation>(tableTransformations);
        this.resources = resources;
        this.offsetBasePath = offsetBasePath;
        this.tables = new ArrayList<SourceTable>(tables);
        this.service = false;
        this.dmlBlacklist = new HashSet<DMLOperation.Type>(dmlBlacklist);
        this.ddlBlacklist = new HashSet<DDLOperation.Type>(ddlBlacklist);
        this.retries = retries;
        this.parallelism = parallelism;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public List<Stage> getStages() {
        return this.stages == null ? Collections.emptyList() : Collections.unmodifiableList(this.stages);
    }

    public String getOffsetBasePath() {
        return this.offsetBasePath == null || this.offsetBasePath.isEmpty() ? "cdap/delta/" : this.offsetBasePath;
    }

    public List<Connection> getConnections() {
        return this.connections == null ? Collections.emptyList() : Collections.unmodifiableList(this.connections);
    }

    public Resources getResources() {
        return this.resources == null ? new Resources(8192, 4) : this.resources;
    }

    public List<SourceTable> getTables() {
        return this.tables == null ? Collections.emptyList() : Collections.unmodifiableList(this.tables);
    }

    public List<TableTransformation> getTableTransformations() {
        return this.tableTransformations == null ? Collections.emptyList() : Collections.unmodifiableList(this.tableTransformations);
    }

    public Set<DMLOperation.Type> getDmlBlacklist() {
        return this.dmlBlacklist == null ? Collections.emptySet() : Collections.unmodifiableSet(this.dmlBlacklist);
    }

    public Set<DDLOperation.Type> getDdlBlacklist() {
        return this.ddlBlacklist == null ? Collections.singleton(DDLOperation.Type.DROP_DATABASE) : Collections.unmodifiableSet(this.ddlBlacklist);
    }

    public RetryConfig getRetryConfig() {
        return this.retries == null ? RetryConfig.DEFAULT : this.retries;
    }

    public ParallelismConfig getParallelism() {
        return this.parallelism == null ? ParallelismConfig.DEFAULT : this.parallelism;
    }

    public boolean isService() {
        return this.service;
    }

    public void validateDraft() {
        this.validate();
    }

    public void validatePipeline() {
        this.validate().orElseThrow(() -> new IllegalArgumentException("A target must be specified."));
    }

    public Stage getSource() {
        return this.getStages().stream().filter(s -> "cdcSource".equals(s.getPlugin().getType())).findFirst().orElseThrow(() -> new IllegalArgumentException("No source stage found."));
    }

    @Nullable
    public Stage getTarget() {
        return this.getStages().stream().filter(s -> "cdcTarget".equals(s.getPlugin().getType())).findFirst().orElse(null);
    }

    private Optional<Stage> validate() {
        Stage sourceStage = null;
        Stage targetStage = null;
        for (Stage stage : this.stages) {
            stage.validate();
            if ("cdcSource".equals(stage.getPlugin().getType())) {
                if (sourceStage != null) {
                    throw new IllegalArgumentException(String.format("Pipeline can only have one source, but '%s' and '%s' are both sources.", sourceStage.getName(), stage.getName()));
                }
                sourceStage = stage;
            }
            if (!"cdcTarget".equals(stage.getPlugin().getType())) continue;
            if (targetStage != null) {
                throw new IllegalArgumentException(String.format("Pipeline can only have one target, but '%s' and '%s' are both targets.", targetStage.getName(), stage.getName()));
            }
            targetStage = stage;
        }
        if (sourceStage == null) {
            throw new IllegalArgumentException("No source found.");
        }
        if (this.tableTransformations != null) {
            for (TableTransformation tableTransformation : this.tableTransformations) {
                tableTransformation.validate();
            }
        }
        return Optional.ofNullable(targetStage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DeltaConfig that = (DeltaConfig)((Object)o);
        return this.service == that.service && Objects.equals(this.description, that.description) && Objects.equals(this.stages, that.stages) && Objects.equals(this.connections, that.connections) && Objects.equals(this.resources, that.resources) && Objects.equals(this.offsetBasePath, that.offsetBasePath) && Objects.equals(this.tables, that.tables) && Objects.equals(this.dmlBlacklist, that.dmlBlacklist) && Objects.equals(this.ddlBlacklist, that.ddlBlacklist) && Objects.equals(this.tableTransformations, that.tableTransformations);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.stages, this.connections, this.resources, this.offsetBasePath, this.tables, this.dmlBlacklist, this.ddlBlacklist, this.service, this.tableTransformations);
    }

    public DeltaConfig updateConfig(ApplicationUpdateContext upgradeContext) throws Exception {
        ArrayList<Stage> upgradedStages = new ArrayList<Stage>();
        for (Stage stage : this.getStages()) {
            upgradedStages.add(stage.updateStage(upgradeContext));
        }
        return new DeltaConfig(this.getDescription(), upgradedStages, this.getConnections(), this.getTableTransformations(), this.getResources(), this.getOffsetBasePath(), this.getTables(), this.getDmlBlacklist(), this.getDdlBlacklist(), this.getRetryConfig(), this.getParallelism());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Stage source;
        private Stage target;
        private String description = "";
        private String offsetBasePath;
        private Resources resources = new Resources();
        private List<SourceTable> tables = new ArrayList<SourceTable>();
        private List<TableTransformation> tableTransformations = new ArrayList<TableTransformation>();
        private Set<DMLOperation.Type> dmlBlacklist = new HashSet<DMLOperation.Type>();
        private Set<DDLOperation.Type> ddlBlacklist = new HashSet<DDLOperation.Type>();
        private RetryConfig retries = RetryConfig.DEFAULT;
        private ParallelismConfig parallelism = ParallelismConfig.DEFAULT;

        private Builder() {
        }

        public Builder setSource(Stage source) {
            this.source = source;
            return this;
        }

        public Builder setTarget(Stage target) {
            this.target = target;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setOffsetBasePath(String offsetBasePath) {
            this.offsetBasePath = offsetBasePath;
            return this;
        }

        public Builder setResources(Resources resources) {
            this.resources = resources;
            return this;
        }

        public Builder setTables(Collection<SourceTable> tables) {
            this.tables.clear();
            this.tables.addAll(tables);
            return this;
        }

        public Builder setTableTransformations(Collection<TableTransformation> tableTransformations) {
            this.tableTransformations.clear();
            this.tableTransformations.addAll(tableTransformations);
            return this;
        }

        public Builder setDMLBlacklist(Collection<DMLOperation.Type> blacklist) {
            this.dmlBlacklist.clear();
            this.dmlBlacklist.addAll(blacklist);
            return this;
        }

        public Builder setDDLBlacklist(Collection<DDLOperation.Type> blacklist) {
            this.ddlBlacklist.clear();
            this.ddlBlacklist.addAll(blacklist);
            return this;
        }

        public Builder setRetryConfig(RetryConfig retryConfig) {
            this.retries = retryConfig;
            return this;
        }

        public Builder setParallelism(ParallelismConfig parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public DeltaConfig build() {
            ArrayList<Stage> stages = new ArrayList<Stage>();
            if (this.source != null) {
                stages.add(this.source);
            }
            if (this.target != null) {
                stages.add(this.target);
            }
            ArrayList<Connection> connections = new ArrayList<Connection>();
            if (this.source != null && this.target != null) {
                connections.add(new Connection(this.source.getName(), this.target.getName()));
            }
            DeltaConfig config = new DeltaConfig(this.description, stages, connections, this.tableTransformations, this.resources, this.offsetBasePath, this.tables, this.dmlBlacklist, this.ddlBlacklist, this.retries, this.parallelism);
            config.validate();
            return config;
        }
    }
}

