/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.proto;

import java.util.Objects;
import javax.annotation.Nullable;

public class DBTable {
    private final String database;
    private final String table;
    private final String schema;

    public DBTable(String database, String table) {
        this(database, null, table);
    }

    public DBTable(String database, @Nullable String schema, String table) {
        this.database = database;
        this.schema = schema;
        this.table = table;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    public void validate() {
        if (this.database == null || this.database.isEmpty()) {
            throw new IllegalArgumentException("The database is not specified. Please specify a database.");
        }
        if (this.table == null || this.table.isEmpty()) {
            throw new IllegalArgumentException("The table is not specified. Please specify a table.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBTable dbTable = (DBTable)o;
        return Objects.equals(this.database, dbTable.database) && Objects.equals(this.schema, dbTable.schema) && Objects.equals(this.table, dbTable.table);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.schema, this.table);
    }
}

