/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.proto;

import java.util.Objects;

public class ColumnTransformation {
    private String columnName;
    private String directive;

    public ColumnTransformation(String columnName, String directive) {
        this.columnName = columnName;
        this.directive = directive;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDirective() {
        return this.directive;
    }

    public void validate() {
        if (this.columnName == null || this.columnName.isEmpty()) {
            throw new IllegalArgumentException(String.format("Column name of a ColumnTransformation for directive %s is null or empty.", this.directive));
        }
        if (this.directive == null || this.directive.isEmpty()) {
            throw new IllegalArgumentException(String.format("Directive of a ColumnTransformation for column %s is be null or empty.", this.columnName));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnTransformation that = (ColumnTransformation)o;
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.directive, that.directive);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.directive);
    }

    public String toString() {
        return String.format("ColumnTransformation(columnName : \"%s\", directive : \"%s\")", this.columnName, this.directive);
    }
}

