/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.proto;

import io.cdap.delta.proto.Plugin;
import java.util.Objects;

public class Stage {
    private final String name;
    private final Plugin plugin;

    public Stage(String name, Plugin plugin) {
        this.name = name;
        this.plugin = plugin;
    }

    public String getName() {
        return this.name;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void validate() {
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Stage is missing a name.");
        }
        try {
            this.plugin.validate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Stage '%s' is invalid: %s", this.name, e.getMessage()));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stage stage = (Stage)o;
        return Objects.equals(this.name, stage.name) && Objects.equals(this.plugin, stage.plugin);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.plugin);
    }
}

