/*
 * Copyright © 2020 Cask Data, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package io.cdap.delta.app;

import java.util.Objects;

/**
 * Uniquely identifies a worker instance.
 */
public class DeltaWorkerId {
  private final DeltaPipelineId pipelineId;
  private final int instanceId;

  public DeltaWorkerId(DeltaPipelineId pipelineId, int instanceId) {
    this.pipelineId = pipelineId;
    this.instanceId = instanceId;
  }

  public DeltaPipelineId getPipelineId() {
    return pipelineId;
  }

  public int getInstanceId() {
    return instanceId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeltaWorkerId that = (DeltaWorkerId) o;
    return instanceId == that.instanceId &&
      Objects.equals(pipelineId, that.pipelineId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pipelineId, instanceId);
  }
}
