/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

public class DMLOperation {
    private final String databaseName;
    private final String schemaName;
    private final String tableName;
    private final Type type;
    private final long ingestTimestampMillis;
    private final int sizeInBytes;

    public DMLOperation(String databaseName, @Nullable String schemaName, String tableName, Type operationType, long ingestTimestampMillis, int sizeInBytes) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.type = operationType;
        this.ingestTimestampMillis = ingestTimestampMillis;
        this.sizeInBytes = sizeInBytes;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Type getType() {
        return this.type;
    }

    public long getIngestTimestampMillis() {
        return this.ingestTimestampMillis;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DMLOperation that = (DMLOperation)o;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && this.type == that.type && this.ingestTimestampMillis == that.ingestTimestampMillis && this.sizeInBytes == that.sizeInBytes;
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        stringJoiner.add("databaseName=" + this.databaseName);
        stringJoiner.add("type=" + (Object)((Object)this.type));
        if (this.schemaName != null) {
            stringJoiner.add("schemaName=" + this.schemaName);
        }
        stringJoiner.add("tableName=" + this.tableName);
        stringJoiner.add("ingestTimestampMillis=" + this.ingestTimestampMillis);
        stringJoiner.add("sizeInBytes=" + this.sizeInBytes);
        return stringJoiner.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.databaseName, this.schemaName, this.tableName, this.type, this.ingestTimestampMillis, this.sizeInBytes});
    }

    public static enum Type {
        INSERT,
        DELETE,
        UPDATE;

    }
}

