/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.delta.api.ChangeEvent;
import io.cdap.delta.api.ChangeType;
import io.cdap.delta.api.DMLOperation;
import io.cdap.delta.api.Offset;
import io.cdap.delta.api.SortKey;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

public class DMLEvent
extends ChangeEvent {
    private final DMLOperation operation;
    private final StructuredRecord row;
    private final StructuredRecord previousRow;
    private final String transactionId;
    private final long ingestTimestampMillis;
    private final String rowId;
    private int sizeInBytes;
    private List<SortKey> sortKeys;

    private DMLEvent(Offset offset, DMLOperation operation, StructuredRecord row, @Nullable StructuredRecord previousRow, @Nullable String transactionId, long ingestTimestampMillis, @Nullable Long sourceTimestampMillis, boolean isSnapshot, @Nullable String rowId, @Nullable List<SortKey> sortKeys) {
        super(offset, isSnapshot, ChangeType.DML, sourceTimestampMillis);
        this.operation = operation;
        this.row = row;
        this.previousRow = previousRow;
        this.transactionId = transactionId;
        this.ingestTimestampMillis = ingestTimestampMillis;
        this.rowId = rowId;
        this.sizeInBytes = -1;
        this.sortKeys = sortKeys;
    }

    public DMLOperation getOperation() {
        return this.operation;
    }

    public StructuredRecord getRow() {
        return this.row;
    }

    @Nullable
    public StructuredRecord getPreviousRow() {
        return this.previousRow;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public long getIngestTimestampMillis() {
        return this.ingestTimestampMillis;
    }

    @Nullable
    public String getRowId() {
        return this.rowId;
    }

    @Nullable
    public List<SortKey> getSortKeys() {
        return this.sortKeys;
    }

    public int getSizeInBytes() {
        if (this.sizeInBytes < 0) {
            this.sizeInBytes = this.operation.getSizeInBytes() + DMLEvent.computeSizeInBytes(this.previousRow);
            if (this.operation.getType() == DMLOperation.Type.DELETE) {
                this.sizeInBytes += DMLEvent.computeSizeInBytes(this.row);
            }
        }
        return this.sizeInBytes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DMLEvent dmlEvent = (DMLEvent)o;
        return this.ingestTimestampMillis == dmlEvent.ingestTimestampMillis && Objects.equals(this.rowId, dmlEvent.rowId) && Objects.equals(this.operation, dmlEvent.operation) && Objects.equals(this.row, dmlEvent.row) && Objects.equals(this.previousRow, dmlEvent.previousRow) && Objects.equals(this.transactionId, dmlEvent.transactionId) && Objects.equals(this.sortKeys, dmlEvent.sortKeys);
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        stringJoiner.add("operation=" + this.operation);
        stringJoiner.add("isSnapshot=" + this.isSnapshot());
        stringJoiner.add("changeType=" + (Object)((Object)this.getChangeType()));
        stringJoiner.add("offset=" + this.getOffset());
        if (this.getSourceTimestampMillis() != null) {
            stringJoiner.add("sourceTimestampMillis=" + this.getSourceTimestampMillis());
        }
        if (this.sortKeys != null && !this.sortKeys.isEmpty()) {
            stringJoiner.add("sortKeys=" + this.sortKeys);
        }
        return stringJoiner.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operation, this.row, this.previousRow, this.transactionId, this.ingestTimestampMillis, this.rowId, this.sortKeys);
    }

    public static Builder builder(DMLEvent event) {
        return new Builder(event);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static int computeSizeInBytes(StructuredRecord row) {
        if (row == null) {
            return 0;
        }
        List fields = row.getSchema().getFields();
        if (fields == null) {
            return 0;
        }
        int sizeInBytes = 0;
        for (Schema.Field field : fields) {
            Schema fieldSchema = field.getSchema();
            fieldSchema = fieldSchema.isNullable() ? fieldSchema.getNonNullable() : fieldSchema;
            Object value = row.get(field.getName());
            if (value == null) continue;
            switch (fieldSchema.getType()) {
                case BOOLEAN: {
                    ++sizeInBytes;
                    break;
                }
                case INT: 
                case FLOAT: 
                case ENUM: {
                    sizeInBytes += 4;
                    break;
                }
                case LONG: 
                case DOUBLE: {
                    sizeInBytes += 8;
                    break;
                }
                case BYTES: {
                    if (value instanceof ByteBuffer) {
                        sizeInBytes += Bytes.toBytes((ByteBuffer)((ByteBuffer)value)).length;
                        break;
                    }
                    sizeInBytes += ((byte[])value).length;
                    break;
                }
                case STRING: {
                    sizeInBytes += ((String)value).getBytes(StandardCharsets.UTF_8).length;
                    break;
                }
            }
        }
        return sizeInBytes;
    }

    public static class Builder
    extends ChangeEvent.Builder<Builder> {
        private DMLOperation.Type operationType;
        private String databaseName;
        private String schemaName;
        private String tableName;
        private StructuredRecord row;
        private StructuredRecord previousRow;
        private String transactionId;
        private long ingestTimestampMillis;
        private String rowId;
        private List<SortKey> sortKeys;

        private Builder() {
        }

        private Builder(DMLEvent event) {
            this.offset = event.getOffset();
            this.operationType = event.getOperation().getType();
            this.databaseName = event.getOperation().getDatabaseName();
            this.schemaName = event.getOperation().getSchemaName();
            this.tableName = event.getOperation().getTableName();
            this.row = event.getRow();
            this.previousRow = event.getPreviousRow();
            this.transactionId = event.getTransactionId();
            this.ingestTimestampMillis = event.getIngestTimestampMillis();
            this.isSnapshot = event.isSnapshot();
            this.sourceTimestampMillis = event.getSourceTimestampMillis();
            this.rowId = event.getRowId();
            this.sortKeys = event.getSortKeys();
        }

        public Builder setOperationType(DMLOperation.Type operationType) {
            this.operationType = operationType;
            return this;
        }

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setRow(StructuredRecord row) {
            this.row = row;
            return this;
        }

        public Builder setPreviousRow(StructuredRecord previousRow) {
            this.previousRow = previousRow;
            return this;
        }

        public Builder setTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder setIngestTimestamp(long ingestTimestampMillis) {
            this.ingestTimestampMillis = ingestTimestampMillis;
            return this;
        }

        public Builder setRowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public Builder setSortKeys(List<SortKey> sortKeys) {
            this.sortKeys = sortKeys;
            return this;
        }

        public DMLEvent build() {
            int sizeInBytes = this.operationType == DMLOperation.Type.INSERT || this.operationType == DMLOperation.Type.UPDATE ? DMLEvent.computeSizeInBytes(this.row) : 0;
            return new DMLEvent(this.offset, new DMLOperation(this.databaseName, this.schemaName, this.tableName, this.operationType, this.ingestTimestampMillis, sizeInBytes), this.row, this.previousRow, this.transactionId, this.ingestTimestampMillis, this.sourceTimestampMillis, this.isSnapshot, this.rowId, this.sortKeys);
        }
    }
}

