/*
 * Copyright © 2020 Cask Data, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package io.cdap.delta.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * Represent row id keys which is uniquely determines the row in a database.
 */
public class RowIdKey {
  private final List<String> rowIdKeys;

  public RowIdKey(List<String> rowIdKeys) {
    this.rowIdKeys = Collections.unmodifiableList(new ArrayList<>(rowIdKeys));
  }

  public List<String> getRowIdKeys() {
    return rowIdKeys;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RowIdKey rowIdKey = (RowIdKey) o;
    return rowIdKeys.equals(rowIdKey.rowIdKeys);
  }

  @Override
  public int hashCode() {
    return Objects.hash(rowIdKeys);
  }
}
