/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

public class DDLOperation {
    private final String databaseName;
    private final String schemaName;
    private final String tableName;
    private final String prevTableName;
    private final Type type;

    public DDLOperation(String databaseName, @Nullable String schemaName, @Nullable String tableName, Type type) {
        this(databaseName, schemaName, tableName, null, type);
    }

    public static DDLOperation createRenameTableOperation(String databaseName, @Nullable String schemaName, String prevTableName, String tableName) {
        if (prevTableName == null || tableName == null) {
            throw new IllegalArgumentException("For table rename ddl operation both previous table name and renamed table names are required.");
        }
        return new DDLOperation(databaseName, schemaName, prevTableName, tableName, Type.RENAME_TABLE);
    }

    private DDLOperation(String databaseName, @Nullable String schemaName, @Nullable String tableName, @Nullable String prevTableName, Type type) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.prevTableName = prevTableName;
        this.type = type;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Nullable
    public String getTableName() {
        return this.tableName;
    }

    @Nullable
    public String getPrevTableName() {
        return this.prevTableName;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DDLOperation that = (DDLOperation)o;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.prevTableName, that.prevTableName) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.databaseName, this.schemaName, this.tableName, this.prevTableName, this.type});
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(", ", "{", "}");
        stringJoiner.add("databaseName=" + this.databaseName);
        stringJoiner.add("type=" + (Object)((Object)this.type));
        if (this.schemaName != null) {
            stringJoiner.add("schemaName=" + this.schemaName);
        }
        if (this.tableName != null) {
            stringJoiner.add("tableName=" + this.tableName);
        }
        if (this.prevTableName != null) {
            stringJoiner.add("prevTableName=" + this.prevTableName);
        }
        return stringJoiner.toString();
    }

    public static enum Type {
        CREATE_DATABASE,
        DROP_DATABASE,
        CREATE_TABLE,
        DROP_TABLE,
        TRUNCATE_TABLE,
        ALTER_TABLE,
        RENAME_TABLE;

    }
}

