/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api.assessment;

import javax.annotation.Nullable;

public class TableNotFoundException
extends Exception {
    public TableNotFoundException(String database, String table, String errorMessage) {
        this(database, null, table, errorMessage);
    }

    public TableNotFoundException(String database, @Nullable String schema, String table, String errorMessage) {
        super(TableNotFoundException.buildErrorMessage(database, schema, table, errorMessage));
    }

    public TableNotFoundException(String database, String table, String errorMessage, Throwable cause) {
        this(database, null, table, errorMessage, cause);
    }

    public TableNotFoundException(String database, @Nullable String schema, String table, String errorMessage, Throwable cause) {
        super(TableNotFoundException.buildErrorMessage(database, schema, table, errorMessage), cause);
    }

    private static String buildErrorMessage(String database, @Nullable String schema, String table, String errorMessage) {
        String schemaInfo = schema == null ? "" : String.format("and schema '%s' ", schema);
        return String.format("Table '%s' in database '%s' %swas not found. %s", table, database, schemaInfo, errorMessage);
    }
}

