/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api.assessment;

import java.util.Objects;

public class Problem {
    private final String name;
    private final String description;
    private final String suggestion;
    private final String impact;
    private final Severity severity;
    private final String table;
    private final String column;

    public Problem(String name, String description, String suggestion, String impact) {
        this(name, description, suggestion, impact, Severity.ERROR);
    }

    public Problem(String name, String description, String suggestion, String impact, Severity severity) {
        this(name, description, suggestion, impact, severity, null, null);
    }

    public Problem(String name, String description, String suggestion, String impact, Severity severity, String table, String column) {
        this.name = name;
        this.description = description;
        this.suggestion = suggestion;
        this.impact = impact;
        this.severity = severity;
        this.table = table;
        this.column = column;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public String getImpact() {
        return this.impact;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Problem that = (Problem)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.suggestion, that.suggestion) && Objects.equals(this.impact, that.impact) && Objects.equals((Object)this.severity, (Object)that.severity) && Objects.equals(this.table, that.table) && Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.suggestion, this.impact, this.severity, this.table, this.column});
    }

    public static enum Severity {
        ERROR,
        WARNING;

    }
}

