/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.delta.api.ChangeEvent;
import io.cdap.delta.api.ChangeType;
import io.cdap.delta.api.DDLOperation;
import io.cdap.delta.api.Offset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class DDLEvent
extends ChangeEvent {
    private final DDLOperation operation;
    private final Schema schema;
    private final List<String> primaryKey;

    private DDLEvent(Offset offset, DDLOperation operation, @Nullable Schema schema, List<String> primaryKey, boolean isSnapshot, @Nullable Long sourceTimestampMillis) {
        super(offset, isSnapshot, ChangeType.DDL, sourceTimestampMillis);
        this.operation = operation;
        this.schema = schema;
        this.primaryKey = Collections.unmodifiableList(new ArrayList<String>(primaryKey));
    }

    public DDLOperation getOperation() {
        return this.operation;
    }

    @Nullable
    public Schema getSchema() {
        return this.schema;
    }

    public List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DDLEvent ddlEvent = (DDLEvent)o;
        return Objects.equals(this.operation, ddlEvent.operation) && Objects.equals(this.schema, ddlEvent.schema) && Objects.equals(this.primaryKey, ddlEvent.primaryKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operation, this.schema, this.primaryKey);
    }

    public static Builder builder(DDLEvent event) {
        return new Builder(event);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ChangeEvent.Builder<Builder> {
        private DDLOperation.Type operation;
        private Schema schema;
        private String databaseName;
        private String schemaName;
        private String prevTableName;
        private String tableName;
        private List<String> primaryKey = new ArrayList<String>();

        private Builder() {
        }

        private Builder(DDLEvent event) {
            this.offset = event.getOffset();
            this.isSnapshot = event.isSnapshot();
            this.operation = event.getOperation().getType();
            this.schema = event.getSchema();
            this.schemaName = event.getOperation().getSchemaName();
            this.databaseName = event.getOperation().getDatabaseName();
            this.prevTableName = event.getOperation().getPrevTableName();
            this.tableName = event.getOperation().getTableName();
            this.primaryKey = event.getPrimaryKey();
        }

        public Builder setOperation(DDLOperation.Type operation) {
            this.operation = operation;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setPrevTableName(String prevTableName) {
            this.prevTableName = prevTableName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setPrimaryKey(List<String> primaryKey) {
            this.primaryKey = new ArrayList<String>(primaryKey);
            return this;
        }

        public DDLEvent build() {
            DDLOperation ddlOperation = this.operation == DDLOperation.Type.RENAME_TABLE ? DDLOperation.createRenameTableOperation(this.databaseName, this.schemaName, this.prevTableName, this.tableName) : new DDLOperation(this.databaseName, this.schemaName, this.tableName, this.operation);
            return new DDLEvent(this.offset, ddlOperation, this.schema, this.primaryKey, this.isSnapshot, this.sourceTimestampMillis);
        }
    }
}

