/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import io.cdap.delta.api.ChangeType;
import io.cdap.delta.api.Offset;
import java.util.Objects;
import javax.annotation.Nullable;

public abstract class ChangeEvent {
    private final Offset offset;
    private final boolean isSnapshot;
    private final ChangeType changeType;
    private final Long sourceTimestampMillis;

    protected ChangeEvent(Offset offset, boolean isSnapshot, ChangeType changeType, @Nullable Long sourceTimestampMillis) {
        this.offset = offset;
        this.isSnapshot = isSnapshot;
        this.changeType = changeType;
        this.sourceTimestampMillis = sourceTimestampMillis;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Nullable
    public Long getSourceTimestampMillis() {
        return this.sourceTimestampMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeEvent that = (ChangeEvent)o;
        return this.isSnapshot == that.isSnapshot && Objects.equals(this.offset, that.offset) && Objects.equals(this.sourceTimestampMillis, that.sourceTimestampMillis) && this.changeType == that.changeType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.offset, this.isSnapshot, this.changeType, this.sourceTimestampMillis});
    }

    public static class Builder<T extends Builder> {
        protected Offset offset;
        protected boolean isSnapshot;
        protected Long sourceTimestampMillis;

        public T setOffset(Offset offset) {
            this.offset = offset;
            return (T)this;
        }

        public T setSnapshot(boolean isSnapshot) {
            this.isSnapshot = isSnapshot;
            return (T)this;
        }

        public T setSourceTimestamp(long sourceTimestampMillis) {
            this.sourceTimestampMillis = sourceTimestampMillis;
            return (T)this;
        }
    }
}

