/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api.assessment;

import java.sql.SQLType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ColumnDetail {
    private final String name;
    private final SQLType type;
    private final boolean nullable;
    private final Map<String, String> properties;

    public ColumnDetail(String name, SQLType type, boolean nullable) {
        this(name, type, nullable, new HashMap<String, String>());
    }

    public ColumnDetail(String name, SQLType type, boolean nullable, Map<String, String> properties) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
    }

    public String getName() {
        return this.name;
    }

    public SQLType getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDetail that = (ColumnDetail)o;
        return this.nullable == that.nullable && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.nullable, this.properties);
    }
}

