/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api.assessment;

import io.cdap.delta.api.assessment.ColumnDetail;
import io.cdap.delta.api.assessment.Problem;
import io.cdap.delta.api.assessment.TableSummary;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TableDetail
extends TableSummary {
    private final List<String> primaryKey;
    private final List<ColumnDetail> columns;
    private final List<Problem> features;

    private TableDetail(String database, String table, @Nullable String schema, List<String> primaryKey, List<ColumnDetail> columns, List<Problem> features) {
        super(database, table, columns.size(), schema);
        this.primaryKey = Collections.unmodifiableList(new ArrayList<String>(primaryKey));
        this.columns = Collections.unmodifiableList(new ArrayList<ColumnDetail>(columns));
        this.features = Collections.unmodifiableList(new ArrayList<Problem>(features));
    }

    public List<String> getPrimaryKey() {
        return this.primaryKey;
    }

    public List<ColumnDetail> getColumns() {
        return this.columns;
    }

    public List<Problem> getFeatures() {
        return this.features;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TableDetail that = (TableDetail)o;
        return Objects.equals(this.primaryKey, that.primaryKey) && Objects.equals(this.columns, that.columns) && Objects.equals(this.features, that.features);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.primaryKey, this.columns, this.features);
    }

    public static Builder builder(String database, String table, String schema) {
        return new Builder(database, table, schema);
    }

    public static class Builder {
        private String database;
        private String table;
        private String schema;
        private List<String> primaryKey = new ArrayList<String>();
        private List<ColumnDetail> columns = new ArrayList<ColumnDetail>();
        private List<Problem> features = new ArrayList<Problem>();

        public Builder(String database, String table, String schema) {
            this.database = database;
            this.table = table;
            this.schema = schema;
        }

        public Builder setPrimaryKey(List<String> primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder setColumns(List<ColumnDetail> columns) {
            this.columns = columns;
            return this;
        }

        public Builder setFeatures(List<Problem> features) {
            this.features = features;
            return this;
        }

        public TableDetail build() {
            return new TableDetail(this.database, this.table, this.schema, this.primaryKey, this.columns, this.features);
        }
    }
}

