/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import io.cdap.delta.api.DDLOperation;
import io.cdap.delta.api.DMLOperation;
import io.cdap.delta.api.SourceColumn;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class SourceTable {
    private final String database;
    private final String table;
    private final String schema;
    private final Set<SourceColumn> columns;
    private final Set<DMLOperation.Type> dmlBlacklist;
    private final Set<DDLOperation.Type> ddlBlacklist;

    public SourceTable(String database, String table) {
        this(database, table, Collections.emptySet());
    }

    public SourceTable(String database, String table, Set<SourceColumn> columns) {
        this(database, table, null, columns, Collections.emptySet(), Collections.emptySet());
    }

    public SourceTable(String database, String table, @Nullable String schema, Set<SourceColumn> columns, Set<DMLOperation.Type> dmlBlacklist, Set<DDLOperation.Type> ddlBlacklist) {
        this.database = database;
        this.table = table;
        this.schema = schema;
        this.columns = columns;
        this.dmlBlacklist = new HashSet<DMLOperation.Type>(dmlBlacklist);
        this.ddlBlacklist = new HashSet<DDLOperation.Type>(ddlBlacklist);
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public Set<SourceColumn> getColumns() {
        return this.columns == null ? Collections.emptySet() : Collections.unmodifiableSet(this.columns);
    }

    public Set<DMLOperation.Type> getDmlBlacklist() {
        return this.dmlBlacklist == null ? Collections.emptySet() : Collections.unmodifiableSet(this.dmlBlacklist);
    }

    @Nullable
    public String getSchema() {
        return this.schema;
    }

    public Set<DDLOperation.Type> getDdlBlacklist() {
        return this.ddlBlacklist == null ? Collections.emptySet() : Collections.unmodifiableSet(this.ddlBlacklist);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceTable that = (SourceTable)o;
        return Objects.equals(this.database, that.database) && Objects.equals(this.table, that.table) && Objects.equals(this.columns, that.columns) && Objects.equals(this.dmlBlacklist, that.dmlBlacklist) && Objects.equals(this.ddlBlacklist, that.ddlBlacklist) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.database, this.table, this.columns, this.dmlBlacklist, this.ddlBlacklist, this.schema);
    }
}

