/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import java.util.Objects;

public class Sequenced<T> {
    private final T event;
    private final long sequenceNumber;
    private static final long UNSUPPORTED_SEQUENCE = -1L;

    public Sequenced(T event) {
        this(event, -1L);
    }

    public Sequenced(T event, long sequenceNumber) {
        this.event = event;
        this.sequenceNumber = sequenceNumber;
    }

    public long getSequenceNumber() {
        if (this.sequenceNumber == -1L) {
            throw new UnsupportedOperationException("This event does not support sequence number.");
        }
        return this.sequenceNumber;
    }

    public T getEvent() {
        return this.event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sequenced sequenced = (Sequenced)o;
        return this.sequenceNumber == sequenced.sequenceNumber && Objects.equals(this.event, sequenced.event);
    }

    public int hashCode() {
        return Objects.hash(this.event, this.sequenceNumber);
    }
}

