/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.api;

import java.util.Objects;

public class SourceProperties {
    private final boolean rowIdSupported;
    private final Ordering ordering;

    private SourceProperties(boolean rowIdSupported) {
        this(rowIdSupported, Ordering.ORDERED);
    }

    private SourceProperties(boolean rowIdSupported, Ordering ordering) {
        this.rowIdSupported = rowIdSupported;
        this.ordering = ordering;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public boolean isRowIdSupported() {
        return this.rowIdSupported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceProperties that = (SourceProperties)o;
        return this.rowIdSupported == that.rowIdSupported && this.ordering == that.ordering;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rowIdSupported, this.ordering});
    }

    public static class Builder {
        private boolean rowIdSupported;
        private Ordering ordering = Ordering.ORDERED;

        public Builder setRowIdSupported(boolean rowIdSupported) {
            this.rowIdSupported = rowIdSupported;
            return this;
        }

        public Builder setOrdering(Ordering ordering) {
            this.ordering = ordering;
            return this;
        }

        public SourceProperties build() throws IllegalArgumentException {
            return new SourceProperties(this.rowIdSupported, this.ordering);
        }
    }

    public static enum Ordering {
        ORDERED,
        UN_ORDERED;

    }
}

